<?php
// Pastikan koneksi tersedia
require_once __DIR__ . "/database/koneksi.php";

// Ambil info vendor (profil & vendor_terbaik)
$vendor = [];
if ($res = $conn->query("SELECT * FROM tb_portfolio_vendor LIMIT 1")) {
    $vendor = $res->fetch_assoc() ?: [];
    $res->free();
}

// Ambil daftar Konsep beserta 1 gambar cover
$konsep = [];
$qKonsep = "
    SELECT k.*,
           (SELECT gk.gambar FROM tb_gambar_konsep gk WHERE gk.id_konsep = k.id LIMIT 1) AS gambar
    FROM tb_konsep k
    ORDER BY k.id DESC
";
if ($res = $conn->query($qKonsep)) {
    while ($row = $res->fetch_assoc()) $konsep[] = $row;
    $res->free();
}

// Ambil daftar Jasa/Produksi (DEKORASI) beserta 1 gambar cover
$dekorasi = [];
$qDekorasi = "
    SELECT p.*,
           (SELECT gp.gambar FROM tb_gambar_produksi gp WHERE gp.id_produksi = p.id LIMIT 1) AS gambar
    FROM tb_produksi p
    WHERE p.jenis = 'PERIZINAN'
    ORDER BY p.id DESC
";
if ($res = $conn->query($qDekorasi)) {
    while ($row = $res->fetch_assoc()) $dekorasi[] = $row;
    $res->free();
}

// Nomor WhatsApp & template pesan (untuk tombol kartu)
$WA_NUMBER   = '6281138203555';
function wa_link($number, $title) {
    $msg = "Halo ProJasa, saya tertarik dengan layanan: " . ($title ?: "Tanpa Judul") . ". Mohon informasinya.";
    return "https://wa.me/{$number}?text=" . rawurlencode($msg);
}
?>
<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <title>ProJasa — Vendor</title>

  <!-- jQuery & Bootstrap 5 -->
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"
          integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4="
          crossorigin="anonymous"></script>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css"
        rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

  <!-- Font Awesome -->
  <link rel="stylesheet" href="assets/plugins/fontawesome-free/css/all.min.css">

  <style>
    :root{
      --brand:#ff5100;
      --brand-dark:#e64900;
    }
    .btn-primary{
      background:var(--brand)!important; border-color:var(--brand)!important;
    }
    .btn-primary:hover{ background:var(--brand-dark)!important; border-color:var(--brand-dark)!important; }
    .navbar-brand:hover, .navbar-nav .nav-item a:hover{ color:var(--brand)!important; }

    .section-muted{ background:#F5F5F7; }
    .heading-lg{ font-weight:700; letter-spacing:.2px; }

    .grid{
      display:grid;
      grid-template-columns:repeat(1, minmax(0, 1fr));
      gap:1.25rem;
    }
    @media(min-width:576px){ .grid{ grid-template-columns:repeat(2, minmax(0, 1fr)); } }
    @media(min-width:992px){ .grid{ grid-template-columns:repeat(3, minmax(0, 1fr)); } }

    .card-tile{
      border:0; border-radius:1rem; overflow:hidden;
      box-shadow:0 8px 25px rgba(0,0,0,.06);
      transition:transform .25s ease, box-shadow .25s ease;
      background:#fff;
    }
    .card-tile:hover{
      transform:translateY(-4px);
      box-shadow:0 16px 45px rgba(0,0,0,.10);
    }
    .tile-media{
      width:100%;
      aspect-ratio: 4/3;
      background:#eef1f5;
      overflow:hidden;
      position:relative;
    }
    .tile-media img{
      width:100%; height:100%; object-fit:cover; display:block;
      transform:scale(1.02);
      transition: transform .35s ease;
    }
    .card-tile:hover .tile-media img{ transform:scale(1.06); }

    .tile-body{ padding:1rem 1rem 1.1rem; }
    .badge-pill{
      background:var(--brand); color:#fff; border-radius:50rem; font-weight:700;
      padding:.35rem .6rem; font-size:.75rem;
    }
    .tile-title{
      margin:.45rem 0 .35rem; font-weight:800;
      display:-webkit-box; -webkit-line-clamp:2; -webkit-box-orient:vertical; overflow:hidden;
    }
    .tile-desc{
      color:#6b7280; font-size:.925rem; min-height:2.6em;
      display:-webkit-box; -webkit-line-clamp:2; -webkit-box-orient:vertical; overflow:hidden;
    }

    /* Modal */
    #itemModal .modal-content{
      border:0; border-radius:1rem; overflow:hidden;
      box-shadow:0 20px 50px rgba(0,0,0,.15);
    }
    #itemModal .hero-wrap{ background:#f6f7f9; position:relative; }
    #itemModal .hero-ratio{
      width:100%; aspect-ratio:16/9; background:#eef1f5; overflow:hidden;
    }
    #itemModal .hero-img{ width:100%; height:100%; object-fit:cover; display:none; }
    #itemModal .hero-badge{
      position:absolute; left:1rem; top:1rem;
      background:var(--brand); color:#fff; font-weight:700;
      padding:.35rem .6rem; border-radius:.5rem; font-size:.8rem;
      box-shadow:0 6px 16px rgba(255,81,0,.35);
    }
    #itemModal .body-wrap{ padding:1rem 1rem 1.25rem; }
    @media(min-width:992px){ #itemModal .body-wrap{ padding:1.25rem 1.5rem 1.5rem; } }
    #itemModal .title{ margin:0 0 .25rem; font-weight:800; letter-spacing:.2px; }
    #itemModal .subtitle{ color:#6b7280; font-size:.925rem; margin-bottom:1rem; }
    #itemModal .prose{ color:#111; line-height:1.7; font-size:.975rem; }
    #itemModal .divider{ height:1px; background:linear-gradient(90deg, rgba(0,0,0,.08), transparent); margin:1rem 0 1.1rem; }
    #itemModal .action-row .btn{ border-radius:.6rem; padding:.55rem .9rem; font-weight:600; }
    #itemModal .modal-body{ max-height:75vh; overflow:auto; }

    .skeleton{
      animation:skeleton 1.1s ease-in-out infinite alternate;
      background:linear-gradient(90deg, #ececec, #f5f5f5, #ececec);
      background-size:200% 100%;
    }
    @keyframes skeleton { to { background-position: 200% 0; } }
  </style>
</head>
<body>

<?php include_once __DIR__ . "/partials/navbar_portfolio.php"; ?>

<!-- Hero: Profil -->
<section class="section-muted">
  <div class="container py-5">
    <div class="row justify-content-center text-center">
      <div class="col-md-8 col-lg-7">
        <h3 class="heading-lg mb-3">YANG KAMI TANGANI?</h3>
        <p class="mb-0"><?= !empty($vendor['profil']) ? $vendor['profil'] : "Data belum diisi" ?></p>
      </div>
    </div>
  </div>
</section>

<!-- Client Kami -->
<section>
  <div class="container py-5">
    <div class="row justify-content-center text-center">
      <div class="col-md-8 col-lg-7">
        <h3 class="heading-lg mb-3">CLIENT KAMI</h3>
        <p><?= !empty($vendor['vendor_terbaik']) ? $vendor['vendor_terbaik'] : "Data belum diisi" ?></p>
        <div class="text-uppercase fw-bold mt-3" style="color:var(--brand);">Klik “Lihat Detail” untuk info</div>
      </div>
    </div>
  </div>
</section>

<!-- Konsep / Tema -->
<section class="section-muted">
  <div class="container py-5">
    <div class="row mb-4">
      <div class="col text-center">
        <h3 class="heading-lg">JASA YANG KAMI TANGANI</h3>
        <div class="text-muted">Pilihan Jasa</div>
      </div>
    </div>

    <div class="grid">
      <?php if (!empty($konsep)): ?>
        <?php foreach ($konsep as $k): ?>
          <?php
            $title  = htmlspecialchars($k['nama'] ?? 'Tanpa Judul');
            $img    = $k['gambar'] ?: 'assets/img/placeholder-4x3.png';
            $detail = $k['detail'] ?? '<em>Belum ada deskripsi.</em>';
            $waHref = wa_link($WA_NUMBER, $k['nama'] ?? 'Tanpa Judul');
          ?>
          <article class="card-tile h-100">
            <div class="tile-media">
              <img src="<?= htmlspecialchars($img) ?>" alt="<?= $title ?>">
            </div>
            <div class="tile-body">
              <span class="badge-pill">Jasa</span>
              <h5 class="tile-title"><?= $title ?></h5>
              <div class="tile-desc"><?= htmlspecialchars(mb_strimwidth(strip_tags($detail), 0, 140, '…', 'UTF-8')) ?></div>
              <div class="d-flex gap-2 mt-3">
                <button
                  class="btn btn-sm btn-outline-secondary"
                  data-bs-toggle="modal" data-bs-target="#itemModal"
                  data-title="<?= $title ?>"
                  data-img="<?= htmlspecialchars($img) ?>"
                  data-detail="<?= htmlspecialchars($detail, ENT_QUOTES) ?>">
                  <i class="far fa-eye me-1"></i> Lihat Detail
                </button>
                <a href="<?= $waHref ?>" target="_blank" rel="noopener" class="btn btn-sm btn-primary">
                  <i class="fab fa-whatsapp me-1"></i> Ajukan
                </a>
              </div>
            </div>
          </article>
        <?php endforeach; ?>
      <?php else: ?>
        <div class="text-center text-muted">Belum ada data Jasa.</div>
      <?php endif; ?>
    </div>
  </div>
</section>

<!-- Produksi: Dekorasi (JASA) -->
<!--<section>
  <div class="container py-5">
    <div class="row mb-4">
      <div class="col text-center">
        <h3 class="heading-lg">JASA</h3>
        <div class="text-muted">Pengurusan / Layanan</div>
      </div>
    </div>

    <div class="grid">
      <?php if (!empty($dekorasi)): ?>
        <?php foreach ($dekorasi as $d): ?>
          <?php
            $title  = htmlspecialchars($d['nama'] ?? 'Tanpa Judul');
            $img    = $d['gambar'] ?: 'assets/img/placeholder-4x3.png';
            $detail = $d['detail'] ?? '<em>Belum ada deskripsi.</em>';
            $waHref = wa_link($WA_NUMBER, $d['nama'] ?? 'Tanpa Judul');
          ?>
          <article class="card-tile h-100">
            <div class="tile-media">
              <img src="<?= htmlspecialchars($img) ?>" alt="<?= $title ?>">
            </div>
            <div class="tile-body">
              <span class="badge-pill">Jasa</span>
              <h5 class="tile-title"><?= $title ?></h5>
              <div class="tile-desc"><?= htmlspecialchars(mb_strimwidth(strip_tags($detail), 0, 140, '…', 'UTF-8')) ?></div>
              <div class="d-flex gap-2 mt-3">
                <button
                  class="btn btn-sm btn-outline-secondary"
                  data-bs-toggle="modal" data-bs-target="#itemModal"
                  data-title="<?= $title ?>"
                  data-img="<?= htmlspecialchars($img) ?>"
                  data-detail="<?= htmlspecialchars($detail, ENT_QUOTES) ?>">
                  <i class="far fa-eye me-1"></i> Lihat Detail
                </button>
                <a href="<?= $waHref ?>" target="_blank" rel="noopener" class="btn btn-sm btn-primary">
                  <i class="fab fa-whatsapp me-1"></i> Ajukan
                </a>
              </div>
            </div>
          </article>
        <?php endforeach; ?>
      <?php else: ?>
        <div class="text-center text-muted">Belum ada data jasa.</div>
      <?php endif; ?>
    </div>
  </div>
</section>
-->
<?php include_once __DIR__ . "/partials/footer_portfolio.php"; ?>

<!-- ===== Modal: Lihat Detail ===== -->
<div class="modal fade" id="itemModal" tabindex="-1" aria-hidden="true" aria-labelledby="itemModalLabel">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content">

      <div class="hero-wrap">
        <div class="hero-ratio skeleton" id="itemModalSkeleton"></div>
        <img id="itemModalImg" src="" alt="" class="hero-img">
        <span class="hero-badge">Detail</span>
      </div>

      <div class="modal-body body-wrap">
        <h4 class="title" id="itemModalLabel">Detail</h4>
        <div class="subtitle" id="itemModalSubtitle">Informasi layanan</div>

        <div class="divider"></div>

        <div id="itemModalDetail" class="prose"></div>

        <div class="divider"></div>

        <div class="d-flex align-items-center justify-content-between action-row">
          <button class="btn btn-outline-secondary" data-bs-dismiss="modal">
            <i class="far fa-times-circle me-1"></i> Tutup
          </button>
          <!-- HREF akan diisi dinamis ke WhatsApp sesuai judul -->
          <a id="btnAjukanModal" href="#" target="_blank" rel="noopener" class="btn btn-primary">
            <i class="fab fa-whatsapp me-1"></i> Ajukan Layanan Ini
          </a>
        </div>
      </div>

    </div>
  </div>
</div>

<script>
  const WA_NUMBER = '<?= $WA_NUMBER ?>';

  function setModalImage(src, title){
    const img = document.getElementById('itemModalImg');
    const sk  = document.getElementById('itemModalSkeleton');
    img.style.display = 'none';
    sk.style.display  = 'block';
    sk.innerHTML = '';

    img.onload = function(){
      sk.style.display = 'none';
      img.style.display = 'block';
    };
    img.onerror = function(){
      sk.innerHTML =
        '<div class="w-100 h-100 d-flex align-items-center justify-content-center text-muted fw-semibold">Gambar tidak dapat dimuat</div>';
    };

    img.src = src || '';
    img.alt = title || 'Detail';
  }

  // Isi modal saat dibuka + set tombol WA
  const itemModal = document.getElementById('itemModal');
  itemModal.addEventListener('show.bs.modal', function (e) {
    const btn    = e.relatedTarget;
    const title  = btn?.getAttribute('data-title')  || 'Detail';
    const img    = btn?.getAttribute('data-img')    || '';
    const detail = btn?.getAttribute('data-detail') || '<em>Belum ada deskripsi.</em>';

    document.getElementById('itemModalLabel').textContent    = title;
    document.getElementById('itemModalSubtitle').textContent = 'Rincian layanan: ' + title;
    itemModal.querySelector('.hero-badge').textContent       = title;
    document.getElementById('itemModalDetail').innerHTML     = detail;

    // Set gambar
    setModalImage(img, title);

    // Set tombol WhatsApp (prefilled message)
    const msg = `Halo ProJasa, saya tertarik dengan layanan: ${title}. Mohon informasinya.`;
    const wa  = `https://wa.me/${WA_NUMBER}?text=${encodeURIComponent(msg)}`;
    document.getElementById('btnAjukanModal').setAttribute('href', wa);
  });

  // Bersihkan saat modal ditutup
  itemModal.addEventListener('hidden.bs.modal', function () {
    document.getElementById('itemModalDetail').innerHTML = '';
    document.getElementById('itemModalImg').setAttribute('src','');
    document.getElementById('itemModalImg').style.display = 'none';
    const sk = document.getElementById('itemModalSkeleton');
    sk.style.display = 'block';
    sk.innerHTML = '';
    document.getElementById('btnAjukanModal').setAttribute('href', '#');
  });
</script>

</body>
</html>
