<?php
session_start();
session_destroy();

include_once("database/koneksi.php");

/* =========================
   Helpers URL & Open Graph
   ========================= */
function baseUrl() {
  $proto = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
  $host  = $_SERVER['HTTP_HOST'] ?? 'localhost';
  $dir   = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\');
  return $proto . '://' . $host . ($dir === '/' ? '' : $dir);
}
function absoluteUrl($path) {
  if (preg_match('~^https?://~i', (string)$path)) return $path;
  return rtrim(baseUrl(), '/') . '/' . ltrim((string)$path, '/');
}

/* =========================
   Helpers YouTube (ID/URL)
   ========================= */
function ytIdFromStored($val) {
  $val = trim((string)$val);
  if (preg_match('/^[a-zA-Z0-9_-]{11}$/', $val)) return $val;
  $parts = @parse_url($val);
  if (!$parts || !isset($parts['host'])) return '';
  $host  = strtolower($parts['host']);
  $path  = $parts['path'] ?? '';
  $query = $parts['query'] ?? '';
  parse_str($query, $q);
  if (!empty($q['v']) && preg_match('/^[a-zA-Z0-9_-]{11}$/', $q['v'])) return $q['v'];
  if (preg_match('#^/embed/([a-zA-Z0-9_-]{11})#', $path, $m))  return $m[1];
  if (preg_match('#^/shorts/([a-zA-Z0-9_-]{11})#', $path, $m)) return $m[1];
  if (preg_match('#^/v/([a-zA-Z0-9_-]{11})#', $path, $m))      return $m[1];
  if (strpos($host, 'youtu.be') !== false && preg_match('#^/([a-zA-Z0-9_-]{11})#', $path, $m)) return $m[1];
  return '';
}
function ytWatchUrl($idOrUrl) {
  $id = ytIdFromStored($idOrUrl);
  return $id ? "https://www.youtube.com/watch?v={$id}" : trim((string)$idOrUrl);
}
function ytThumb($idOrUrl) {
  $id = ytIdFromStored($idOrUrl);
  return $id ? "https://img.youtube.com/vi/{$id}/hqdefault.jpg" : "assets/img/placeholder-16x9.jpg";
}

/* =========================
   Data dari Database
   ========================= */
// Carousel
$caraousel = [];
if ($res = $conn->query("SELECT * FROM tb_caraousel")) { $caraousel = $res->fetch_all(MYSQLI_ASSOC); }

// Portfolio home
$data = [];
if ($res = $conn->query("SELECT * FROM tb_portfolio_home")) { $data = $res->fetch_assoc() ?: []; }

// Paket (termasuk nama/detail konsep dan total harga)
$resPaket = $conn->query("
  SELECT 
    tb_paket_wedding.*,
    (SELECT nama   FROM tb_konsep    WHERE id=tb_paket_wedding.konsep)  AS konsep,
    (SELECT detail FROM tb_konsep    WHERE id=tb_paket_wedding.konsep)  AS detail_konsep,
    (
      COALESCE((SELECT harga FROM tb_produksi  WHERE id=tb_paket_wedding.dekorasi),0) +
      COALESCE((SELECT harga FROM tb_produksi  WHERE id=tb_paket_wedding.dokumentasi),0) +
      COALESCE((SELECT harga FROM tb_equipment WHERE id=tb_paket_wedding.lighting),0)   +
      COALESCE((SELECT harga FROM tb_equipment WHERE id=tb_paket_wedding.sound),0)      +
      COALESCE((SELECT harga FROM tb_talent    WHERE id=tb_paket_wedding.band),0)       +
      COALESCE((SELECT harga FROM tb_talent    WHERE id=tb_paket_wedding.mc),0)         +
      COALESCE((SELECT harga FROM tb_talent    WHERE id=tb_paket_wedding.mua),0)
    ) AS total
  FROM tb_paket_wedding
  ORDER BY id DESC
");

// Video (hasil kerja)
$videosRes = $conn->query("SELECT id, link_yt FROM tb_hasil_kerja ORDER BY id DESC");

/* =========================
   Open Graph Defaults
   ========================= */
$OG_TITLE = 'ProJasa — Pengurusan PBG, SLF, As Built Drawing, UKL-UPL';
$OG_DESC  = 'Urus perizinan bangunan & legalitas usaha tanpa ribet. Proses cepat, resmi, dan terverifikasi. Konsultasi gratis via WhatsApp.';
$OG_IMAGE = absoluteUrl('assets/social/og-projasa.jpg'); // 1200x630
$OG_URL   = $OG_CANONICAL = absoluteUrl(basename($_SERVER['REQUEST_URI'] ?: 'portfolio.php'));

/* =========================
   OG Override per Item (?paket=ID)
   ========================= */
if (isset($_GET['paket'])) {
  $pid = (int) $_GET['paket'];
  if ($q = $conn->query("SELECT id, nama, keterangan, gambar FROM tb_paket_wedding WHERE id={$pid} LIMIT 1")) {
    if ($it = $q->fetch_assoc()) {
      $OG_TITLE = 'Paket: ' . $it['nama'] . ' — ProJasa';
      $desc     = trim((string)$it['keterangan']);
      $OG_DESC  = mb_strlen($desc) > 140 ? mb_substr($desc, 0, 140).'…' : ($desc ?: $OG_DESC);
      $imgRaw   = trim((string)$it['gambar']);
      $OG_IMAGE = absoluteUrl($imgRaw ?: 'assets/social/og-projasa.jpg');
      $OG_URL   = $OG_CANONICAL = absoluteUrl('portfolio.php?paket=' . $pid);
    }
  }
}

// Efek carousel berurutan (akan diulang kalau slide > efek)
$effects = ['kenburns','pan-left','pan-right','tilt','zoom-out','fade'];

/* =========================
   Helper: pilih tabel pengajuan (cari tb_pengajuan atau tb_pegajuan)
   ========================= */
function findPengajuanTable($conn) {
  $candidates = ['tb_pengajuan', 'tb_pegajuan', 'pengajuan', 'tb_pegajuan']; // tambahan defensif
  foreach ($candidates as $t) {
    $tEsc = $conn->real_escape_string($t);
    $res = @$conn->query("SHOW TABLES LIKE '{$tEsc}'");
    if ($res && $res->num_rows) return $t;
  }
  return null;
}

$pengajuanTable = findPengajuanTable($conn);
?>
<!doctype html>
<html lang="id">
<head>
  <!-- Meta -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <title>ProJasa</title>

  <!-- Canonical & Open Graph -->
  <link rel="canonical" href="<?= htmlspecialchars($OG_CANONICAL); ?>"/>
  <meta property="og:type" content="website">
  <meta property="og:title" content="<?= htmlspecialchars($OG_TITLE); ?>">
  <meta property="og:description" content="<?= htmlspecialchars($OG_DESC); ?>">
  <meta property="og:url" content="<?= htmlspecialchars($OG_URL); ?>">
  <meta property="og:image" content="<?= htmlspecialchars($OG_IMAGE); ?>">
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="630">
  <meta property="og:site_name" content="ProJasa">

  <!-- Twitter Card -->
  <meta name="twitter:card" content="summary_large_image">
  <meta name="twitter:title" content="<?= htmlspecialchars($OG_TITLE); ?>">
  <meta name="twitter:description" content="<?= htmlspecialchars($OG_DESC); ?>">
  <meta name="twitter:image" content="<?= htmlspecialchars($OG_IMAGE); ?>">

  <!-- Bootstrap CSS (v5) -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet">

  <!-- Font Awesome -->
  <link rel="stylesheet" href="assets/plugins/fontawesome-free/css/all.min.css">

  <!-- Animate.css -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>

  <style>
    /* Branding button */
    .btn-primary { border-color: #ff5100; background-color: #ff5100 !important; }
    .btn-primary:hover { border-color: #e64900; background-color: #e64900 !important; }
    #btn-login:hover { background-color: #ff5100; color: #fff; }
    .navbar-brand:hover, .navbar-nav .nav-item a:hover { color: #ff5100 !important; }

    /* Carousel wrapper */
    #portfolioCarousel { height: 85vh; overflow: hidden; position: relative; }
    #portfolioCarousel .carousel-item { height: 85vh; position: relative; }

    .slide-bg{
      position:absolute; inset:0;
      background-size:cover; background-position:center;
      transform-origin:center;
      will-change: transform, opacity, filter;
    }
    .carousel-overlay { position: absolute; inset: 0; background: rgba(0,0,0,.55); z-index: 1; }
    .carousel-caption { z-index: 2; color: #fff; text-align: left; padding-left: 10%; max-width: 650px; }
    #portfolioCarousel h1, #portfolioCarousel p, #portfolioCarousel a { animation-duration: 1.2s; }

    :root { --slide-anim-duration: 3000ms; }

    @keyframes kb-zoom { 0%{transform:scale(1) translate(0,0);} 100%{transform:scale(1.15) translate(12px,-10px);} }
    @keyframes pan-left { 0%{transform:scale(1.05) translateX(10%);} 100%{transform:scale(1.05) translateX(0);} }
    @keyframes pan-right{ 0%{transform:scale(1.05) translateX(-10%);} 100%{transform:scale(1.05) translateX(0);} }
    @keyframes tilt-zoom { 0%{transform:scale(1) rotate(0);} 100%{transform:scale(1.08) rotate(0.6deg);} }
    @keyframes zoom-out  { 0%{transform:scale(1.12);} 100%{transform:scale(1);} }
    @keyframes fade-soft { 0%{opacity:.65; filter: blur(2px);} 100%{opacity:1; filter: blur(0);} }

    .animate-kenburns { animation: kb-zoom var(--slide-anim-duration) ease-in-out both; }
    .animate-pan-left { animation: pan-left var(--slide-anim-duration) ease-out both; }
    .animate-pan-right{ animation: pan-right var(--slide-anim-duration) ease-out both; }
    .animate-tilt     { animation: tilt-zoom var(--slide-anim-duration) ease-in-out both; }
    .animate-zoom-out { animation: zoom-out var(--slide-anim-duration) ease-out both; }
    .animate-fade     { animation: fade-soft var(--slide-anim-duration) ease-out both; }

    /* Cards & sections */
    .card { border-radius: .75rem; }
    .shadow-soft { box-shadow: 0 6px 20px rgba(0,0,0,.08); }

    /* Video section */
    .video-card { border: 0; border-radius: .75rem; overflow: hidden; }
    .video-thumb-wrap { aspect-ratio: 16 / 9; background: #f6f7f9; position: relative; }
    .video-thumb { height: 100%; object-fit: cover; width: 100%; display: block; }
    .btn-play {
      position: absolute; inset: 0; margin: auto; width: 56px; height: 56px;
      display: grid; place-items: center; border-radius: 50%;
    }
    .btn-play i { font-size: 1rem; }
    .video-card:hover .video-thumb { transform: scale(1.02); transition: transform .2s ease; }
    .video-link {
      display: inline-block; max-width: 100%;
      white-space: nowrap; overflow: hidden; text-overflow: ellipsis;
    }

    /* Floating WhatsApp (kanan bawah, di atas panah) */
    :root{
      --fab-size: 56px;   /* perkiraan ukuran tombol panah */
      --fab-gap:  12px;   /* jarak antar tombol */
      --arrow-bottom: 18px; /* jarak panah dari bawah */
    }
    .wa-float{
      position: fixed;
      right: 18px;
      bottom: calc(var(--arrow-bottom) + var(--fab-size) + var(--fab-gap));
      width: 56px; height: 56px; border-radius: 50%;
      display:flex;align-items:center;justify-content:center;
      background:#25D366;color:#fff;
      box-shadow:0 10px 24px rgba(0,0,0,.22);
      z-index: 1060;
      transition: transform .12s ease, box-shadow .12s ease, background .2s ease;
    }
    .wa-float i{ font-size:28px; line-height:1; }
    .wa-float:hover{ transform: translateY(-2px); box-shadow:0 14px 28px rgba(0,0,0,.25); background:#1ebe5d; }

    /* Paket */
    .btn-detail {
      display: inline-flex; align-items: center; gap: .4rem;
      font-weight: 600;
      border-radius: .6rem;
      box-shadow: 0 6px 18px rgba(0,0,0,.06);
    }
    .btn-detail i { font-size: .95rem; }
    .card-img-top { height: 220px; object-fit: cover; }
    .modal-hero { max-height: 420px; object-fit: cover; }
    .badge-soft {
      background: rgba(255, 81, 0, .12);
      color: #ff5100;
      border: 1px solid rgba(255,81,0,.25);
      font-weight: 600;
    }
    .price-box {
      background: #fff7f3;
      border: 1px dashed #ff5100;
      border-radius: .75rem;
      padding: .9rem 1rem;
    }

    /* Responsive */
    @media (max-width: 576px){
      #portfolioCarousel, #portfolioCarousel .carousel-item { height: 60vh; }
      .carousel-caption { padding-left: 5%; max-width: 520px; }
      .btn-play { width: 48px; height: 48px; }
      .wa-float{ bottom: 22px; width:52px; height:52px; }
      .wa-float i{ font-size:26px; }
    }

    /* Utility */
    img { max-width: 100%; height: auto; }
  </style>
</head>
<body>

<?php include_once("partials/navbar_portfolio.php"); ?>

<!-- ===== Hero Carousel ===== -->
<div id="portfolioCarousel" class="carousel slide" data-bs-ride="carousel">
  <!-- Indicators -->
  <div class="carousel-indicators">
    <?php if (count($caraousel)): ?>
      <button type="button" data-bs-target="#portfolioCarousel" data-bs-slide-to="0" class="active" aria-current="true"></button>
    <?php endif; ?>
    <?php for ($i=1; $i < count($caraousel); $i++): ?>
      <button type="button" data-bs-target="#portfolioCarousel" data-bs-slide-to="<?= $i ?>"></button>
    <?php endfor; ?>
  </div>

  <!-- Slides -->
  <div class="carousel-inner">
    <?php if (count($caraousel)):
      $firstEffect = $effects[0 % count($effects)];
    ?>
      <div class="carousel-item active" data-effect="<?= $firstEffect ?>">
        <div class="slide-bg" style="background-image:url('<?= htmlspecialchars($caraousel[0]['gambar']) ?>');"></div>
        <div class="carousel-overlay"></div>
        <div class="carousel-caption d-flex flex-column justify-content-center h-100">
          <h1 class="display-5 fw-bold animate__animated animate__fadeInDown"><?= htmlspecialchars($caraousel[0]['judul']) ?></h1>
          <p class="lead animate__animated animate__fadeInUp"><?= htmlspecialchars($caraousel[0]['keterangan']) ?></p>
          <a href="https://wa.me/628125532111" target="_blank" rel="noopener" class="btn btn-light btn-lg mt-3 animate__animated animate__fadeInUp">Hubungi Kami</a>
        </div>
      </div>
    <?php endif; ?>

    <?php for ($i=1; $i < count($caraousel); $i++):
      $effect = $effects[$i % count($effects)];
    ?>
      <div class="carousel-item" data-effect="<?= $effect ?>">
        <div class="slide-bg" style="background-image:url('<?= htmlspecialchars($caraousel[$i]['gambar']) ?>');"></div>
        <div class="carousel-overlay"></div>
        <div class="carousel-caption d-flex flex-column justify-content-center h-100">
          <h1 class="display-5 fw-bold animate__animated animate__fadeInDown"><?= htmlspecialchars($caraousel[$i]['judul']) ?></h1>
          <p class="lead animate__animated animate__fadeInUp"><?= htmlspecialchars($caraousel[$i]['keterangan']) ?></p>
          <a href="https://wa.me/628125532111" target="_blank" rel="noopener" class="btn btn-light btn-lg mt-3 animate__animated animate__fadeInUp">Hubungi Kami</a>
        </div>
      </div>
    <?php endfor; ?>
  </div>

  <!-- Controls -->
  <?php if (count($caraousel) > 1): ?>
    <button class="carousel-control-prev" type="button" data-bs-target="#portfolioCarousel" data-bs-slide="prev">
      <span class="carousel-control-prev-icon"></span>
    </button>
    <button class="carousel-control-next" type="button" data-bs-target="#portfolioCarousel" data-bs-slide="next">
      <span class="carousel-control-next-icon"></span>
    </button>
  <?php endif; ?>
</div>

<!-- ===== Konten Utama ===== -->
<div class="container-fluid">


  <!-- CTA & Profil -->
  <div class="row justify-content-center mb-3 bg-light">
    <div class="col-md-8 col-xl-6">
      <div class="text-center mt-4">
        <a href="https://wa.me/628125532111" target="_blank" rel="noopener" class="btn btn-primary mt-4">Hubungi Disini</a>
        <div class="py-4">
          <h3 class="fw-bold">APA ITU ProJasa?</h3>
          <p><?= isset($data['profil']) ? $data['profil'] : "Data belum diisi" ?></p>
        </div>
      </div>
    </div>
  </div>

  <!-- ===== Telusuri status pengajuan Anda (dengan kolom konsep dari tb_konsep) ===== -->
  <div class="row justify-content-center my-5">
    <div class="col-md-8 col-lg-10">
      <div class="card shadow-sm">
        <div class="card-body">
          <h5 class="card-title fw-bold">Telusuri status pengajuan Anda</h5>
          <p class="text-muted small mb-3">Masukkan Nama atau ID pengajuan untuk melihat status terakhir.</p>

          <!-- Form pencarian -->
          <form class="row g-2" method="get" action="<?= htmlspecialchars(basename($_SERVER['PHP_SELF'])); ?>">
            <div class="col-9 col-md-10">
              <input type="search" name="search_pengajuan" class="form-control" placeholder="Nama / ID Pengajuan" value="<?= isset($_GET['search_pengajuan']) ? htmlspecialchars($_GET['search_pengajuan']) : '' ?>">
            </div>
            <div class="col-3 col-md-2 d-grid">
              <button type="submit" class="btn btn-primary">Telusuri</button>
            </div>
          </form>

          <?php
          $results = null;
          $q = null;
          if (!empty($_GET['search_pengajuan'])):
            $q = trim((string)$_GET['search_pengajuan']);

            // Pastikan tabel pengajuan ditemukan
            if (!$pengajuanTable) {
              $errorMsg = 'Tabel pengajuan tidak ditemukan di database.';
            } else {
              // Deskripsikan tabel untuk mengetahui kolom yang tersedia
              $cols = [];
              $descRes = $conn->query("DESCRIBE `{$pengajuanTable}`");
              if ($descRes) {
                while ($c = $descRes->fetch_assoc()) $cols[] = $c['Field'];
              }

              // Cari kolom yang merefer ke tb_konsep (nama umum: konsep, konsep_id, id_konsep)
              $konsepCandidates = ['konsep','konsep_id','id_konsep','idkonsep','id_konsep'];
              $konsepRefCol = null;
              foreach ($konsepCandidates as $cand) {
                if (in_array($cand, $cols)) { $konsepRefCol = $cand; break; }
              }

              // Siapkan parts WHERE dinamis berdasarkan kolom yg ada
              $whereParts = [];
              $bindTypes = '';
              $bindValues = [];

              // ID
              $searchId = ctype_digit($q) ? (int)$q : 0;
              $whereParts[] = "(`{$pengajuanTable}`.`id` = ?)";
              $bindTypes .= 'i';
              $bindValues[] = $searchId;

              // Nama-like columns
              $nameCols = array_filter($cols, function($c){
                $cLower = strtolower($c);
                return strpos($cLower,'nama') !== false || strpos($cLower,'name') !== false || in_array($cLower, ['nama_l','nama_i','full_name','nama_pengaju']);
              });
              // Nik-like columns
              $nikCols = array_filter($cols, function($c){
                $cLower = strtolower($c);
                return strpos($cLower,'nik') !== false || in_array($cLower, ['nik','nik_l','no_nik']);
              });

              // Jika ada name-like columns, tambahkan LIKE clauses
              if (count($nameCols)) {
                $likeParts = [];
                foreach ($nameCols as $col) {
                  $likeParts[] = "`{$pengajuanTable}`.`{$col}` LIKE ?";
                  $bindTypes .= 's';
                  $bindValues[] = '%'.$q.'%';
                }
                $whereParts[] = '(' . implode(' OR ', $likeParts) . ')';
              }

              // Jika ada nik-like columns, tambahkan LIKE clauses
              if (count($nikCols)) {
                $likeParts = [];
                foreach ($nikCols as $col) {
                  $likeParts[] = "`{$pengajuanTable}`.`{$col}` LIKE ?";
                  $bindTypes .= 's';
                  $bindValues[] = '%'.$q.'%';
                }
                $whereParts[] = '(' . implode(' OR ', $likeParts) . ')';
              }

              // Jika tidak ada name/nik columns ditemukan, tambahkan fallback: cari pada kolom keterangan bila ada
              if (!count($nameCols) && !count($nikCols)) {
                if (in_array('keterangan', $cols)) {
                  $whereParts[] = "(`{$pengajuanTable}`.`keterangan` LIKE ?)";
                  $bindTypes .= 's';
                  $bindValues[] = '%'.$q.'%';
                }
              }

              // Susun SELECT & JOIN jika ada referensi konsep
              $selectCols = "`{$pengajuanTable}`.*";
              $joinSql = '';
              if ($konsepRefCol) {
                // tambahkan nama konsep dari tb_konsep
                $selectCols .= ", tb_konsep.nama AS konsep_nama";
                $joinSql = " LEFT JOIN tb_konsep ON `{$pengajuanTable}`.`{$konsepRefCol}` = tb_konsep.id ";
              }

              // Susun SQL final
              $whereSql = $whereParts ? implode(' OR ', $whereParts) : '1';
              $sql = "SELECT {$selectCols} FROM `{$pengajuanTable}` {$joinSql} WHERE {$whereSql} ORDER BY tanggal_pengajuan DESC LIMIT 50";

              // Prepare dan bind dinamis
              if ($stmt = $conn->prepare($sql)) {
                if ($bindTypes !== '') {
                  // bind_param membutuhkan variable references
                  $refs = [];
                  $refs[] = & $bindTypes;
                  for ($i = 0; $i < count($bindValues); $i++) {
                    $refs[] = & $bindValues[$i];
                  }
                  call_user_func_array([$stmt, 'bind_param'], $refs);
                }
                $stmt->execute();
                $res = $stmt->get_result();
                $results = $res->fetch_all(MYSQLI_ASSOC);
                $stmt->close();
              } else {
                // fallback query (escape user input) — sebaiknya jarang dipakai
                $esc = $conn->real_escape_string($q);
                $fallbackWhere = "id = '{$esc}' OR keterangan LIKE '%{$esc}%'";
                if (in_array('nama_l', $cols)) $fallbackWhere .= " OR nama_l LIKE '%{$esc}%'";
                if (in_array('nama_I', $cols)) $fallbackWhere .= " OR nama_I LIKE '%{$esc}%'";
                if (in_array('nama', $cols)) $fallbackWhere .= " OR nama LIKE '%{$esc}%'";
                if (in_array('nik', $cols)) $fallbackWhere .= " OR nik LIKE '%{$esc}%'";
                $fallbackSql = "SELECT * FROM `{$pengajuanTable}` WHERE {$fallbackWhere} ORDER BY tanggal_pengajuan DESC LIMIT 50";
                if ($r = $conn->query($fallbackSql)) {
                  $results = $r->fetch_all(MYSQLI_ASSOC);
                } else {
                  $errorMsg = 'Terjadi kesalahan saat mencari data.';
                }
              }
            } // end pengajuanTable exists
          endif;
          ?>

          <div class="mt-3">
            <?php if (isset($errorMsg)): ?>
              <div class="alert alert-danger mb-0"><?= htmlspecialchars($errorMsg) ?></div>
            <?php elseif (isset($results)): ?>
              <?php if (count($results) === 0): ?>
                <div class="alert alert-warning mb-0">Tidak ditemukan pengajuan yang cocok untuk: <strong><?= htmlspecialchars($q) ?></strong>.</div>
              <?php else: ?>
                <div class="table-responsive mt-2">
                  <table class="table table-sm table-bordered align-middle mb-0">
                    <thead class="table-light">
                      <tr>
                        <th style="width: 6%;">#ID</th>
                        <th>Nama</th>
                        <th style="width: 16%;">Tanggal Pengajuan</th>
                        <th style="width: 12%;">Status</th>
                        <th style="width: 18%;">Jenis Jasa</th>
                        <th>Keterangan</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php foreach ($results as $row): ?>
                        <tr>
                          <td><?= (int)($row['id'] ?? 0) ?></td>
                          <td>
                            <?php
                              // Pilih kolom nama terbaik
                              $name = '';
                              foreach (['nama_l','nama_I','nama_i','nama','full_name','nama_pengaju'] as $ncol) {
                                if (isset($row[$ncol]) && trim($row[$ncol]) !== '') { $name = $row[$ncol]; break; }
                              }
                              // fallback: ambil kolom non-id, non-tanggal, non-status, non-keterangan untuk ditampilkan sebagai nama
                              if ($name === '') {
                                foreach ($row as $k=>$v) {
                                  if (in_array($k, ['id','tanggal_pengajuan','status','keterangan','konsep_nama'])) continue;
                                  if (trim((string)$v) !== '') { $name = $v; break; }
                                }
                              }
                              echo htmlspecialchars($name ?: '—');
                              // tampilkan NIK bila ada
                              foreach (['nik_l','nik','no_nik'] as $ncol) {
                                if (isset($row[$ncol]) && trim($row[$ncol]) !== '') {
                                  echo '<div class="small text-muted">NIK: '.htmlspecialchars($row[$ncol]).'</div>';
                                  break;
                                }
                              }
                            ?>
                          </td>
                          <td class="small text-nowrap">
                            <?php
                              $rawDate = $row['tanggal_pengajuan'] ?? '';
                              if ($rawDate && strtotime($rawDate) !== false) {
                                echo htmlspecialchars(date('d M Y H:i', strtotime($rawDate)));
                              } else {
                                echo '—';
                              }
                            ?>
                          </td>
                          <td>
                            <?php
                              $st = trim((string)($row['status'] ?? ''));
                              $badgeClass = 'secondary';
                              if (strcasecmp($st, 'Pending') === 0 || stripos($st,'pending')!==false) $badgeClass = 'warning';
                              elseif (strcasecmp($st, 'Disetujui') === 0 || stripos($st,'setuju')!==false || stripos($st,'terverifikasi')!==false) $badgeClass = 'success';
                              elseif (stripos($st, 'tolak') !== false || strcasecmp($st, 'Ditolak') === 0) $badgeClass = 'danger';
                            ?>
                            <span class="badge bg-<?= $badgeClass ?>"><?= htmlspecialchars($st ?: '—') ?></span>
                          </td>

                          <td class="small">
                            <?= isset($row['konsep_nama']) && trim($row['konsep_nama']) !== '' ? htmlspecialchars($row['konsep_nama']) : '—' ?>
                          </td>

                          <td class="small"><?= nl2br(htmlspecialchars($row['keterangan'] ?? '—')) ?></td>
                        </tr>
                      <?php endforeach; ?>
                    </tbody>
                  </table>
                </div>
              <?php endif; ?>
            <?php endif; ?>
          </div>

        </div>
      </div>
    </div>
  </div>
  <!-- ===== End Telusuri status pengajuan Anda ===== -->

  <!-- Alasan -->
  <div class="row justify-content-center">
    <div class="col-md-8 col-xl-6">
      <div class="text-center py-4">
        <h3 class="fw-bold">ALASAN KENAPA HARUS PAKAI PROJASA</h3>
        <p><?= isset($data['alasan_pengguna']) ? $data['alasan_pengguna'] : "Data belum diisi" ?></p>
      </div>
    </div>
  </div>

  <!-- Kelebihan -->
  <div class="row justify-content-center">
    <div class="col-md-12 text-center py-4">
      <div class="row justify-content-center">
        <div class="col-sm-6 col-md-3 col-xl-2 mb-4">
          <div class="card border-0 shadow-soft h-100">
            <div class="card-body">
              <div class="mb-4"><i class="fas fa-user-clock fa-3x" style="color:#ff5100;"></i></div>
              <h5 class="fw-bold">Proses Mudah & Cepat</h5>
              <p><?= isset($data['kelebihan1']) ? $data['kelebihan1'] : "Data belum diisi" ?></p>
            </div>
          </div>
        </div>
        <div class="col-sm-6 col-md-3 col-xl-2 mb-4">
          <div class="card border-0 shadow-soft h-100">
            <div class="card-body">
              <div class="mb-4"><i class="fas fa-coins fa-3x text-warning"></i></div>
              <h5 class="fw-bold">Terpercaya & Terverifikasi Resmi</h5>
              <p><?= isset($data['kelebihan2']) ? $data['kelebihan2'] : "Data belum diisi" ?></p>
            </div>
          </div>
        </div>
        <div class="col-sm-6 col-md-3 col-xl-2 mb-4">
          <div class="card border-0 shadow-soft h-100">
            <div class="card-body">
              <div class="mb-4"><i class="fas fa-users fa-3x" style="color:#ff5100;"></i></div>
              <h5 class="fw-bold">Layanan Lengkap dalam Satu Tempat</h5>
              <p><?= isset($data['kelebihan3']) ? $data['kelebihan3'] : "Data belum diisi" ?></p>
            </div>
          </div>
        </div>
        <div class="col-sm-6 col-md-3 col-xl-2 mb-4">
          <div class="card border-0 shadow-soft h-100">
            <div class="card-body">
              <div class="mb-4"><i class="fas fa-clipboard fa-3x text-secondary"></i></div>
              <h5 class="fw-bold">Pengalaman & Kepuasan Klien</h5>
              <p><?= isset($data['kelebihan4']) ? $data['kelebihan4'] : "Data belum diisi" ?></p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Paket Jasa -->
  <div class="row justify-content-center">
    <div class="col-md-8 col-xl-6 text-center">
      <h3 class="fw-bold py-4">PAKET JASA KAMI</h3>
    </div>
  </div>

  <div class="row row-cols-1 row-cols-md-3 g-4 mb-5 px-3 px-md-5 justify-content-center">
    <?php if ($resPaket): while ($row = $resPaket->fetch_assoc()): ?>
      <?php
        $raw = trim((string)($row['gambar'] ?? ''));
        $isUrl = preg_match('~^https?://~i', $raw);
        $abs   = $raw ? __DIR__ . '/' . ltrim($raw, '/') : '';
        $exists = $isUrl ? true : ($raw && @is_file($abs));
        $imgSrc = $exists ? $raw : 'assets/img/placeholder-paket.jpg';
        $modalId = 'paketModal' . (int)$row['id'];
        $shareUrlThis = absoluteUrl('portfolio.php?paket='.(int)$row['id']);
      ?>
      <div class="col" style="max-width: 22rem;">
        <div class="card h-100 shadow-sm">
          <img src="<?= htmlspecialchars($imgSrc) ?>" class="card-img-top" alt="paket">
          <div class="card-body text-center">
            <h5 class="card-title mb-2"><?= htmlspecialchars($row['nama']); ?></h5>
            <?php
              $ket = trim((string)$row['keterangan']);
              $ketShort = mb_strlen($ket) > 90 ? mb_substr($ket, 0, 90) . '…' : $ket;
            ?>
            <p class="card-text text-muted mb-3"><?= htmlspecialchars($ketShort); ?></p>

            <div class="d-flex justify-content-center gap-2 flex-wrap mb-2">
              <button type="button" class="btn btn-primary btn-detail"
                      data-bs-toggle="modal" data-bs-target="#<?= $modalId; ?>">
                <i class="fas fa-eye"></i> Lihat Detail
              </button>

              <!-- Share per-paket -->
              <a class="btn btn-outline-success btn-detail"
                 href="https://api.whatsapp.com/send?text=<?= urlencode($row['nama'].' — '.$shareUrlThis); ?>"
                 target="_blank" rel="noopener">
                <i class="fab fa-whatsapp"></i> Share
              </a>
              <a class="btn btn-outline-primary btn-detail"
                 href="https://www.facebook.com/sharer/sharer.php?u=<?= urlencode($shareUrlThis); ?>"
                 target="_blank" rel="noopener">
                <i class="fab fa-facebook-f"></i> Share
              </a>
            </div>
          </div>
        </div>
      </div>

      <!-- Modal Paket -->
      <div class="modal fade" id="<?= $modalId; ?>" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-scrollable">
          <div class="modal-content">
            <div class="modal-header border-0 pb-0">
              <div>
                <span class="badge badge-soft mb-2">Paket Jasa</span>
                <h5 class="modal-title"><?= htmlspecialchars($row['nama']); ?></h5>
              </div>
              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
            </div>

            <div class="modal-body pt-0 p-0">
              <img src="<?= htmlspecialchars($imgSrc) ?>" class="w-100 modal-hero" alt="paket">
              <div class="p-4">
                <?php
                  $dkRaw  = (string)$row['detail_konsep'];
                  $dkHtml = htmlspecialchars_decode($dkRaw, ENT_QUOTES);
                  $dkSafe = strip_tags($dkHtml, '<p><br><ol><ul><li><strong><b><em><i><u><h1><h2><h3>');
                ?>
                <div class="mb-3"><?= $dkSafe; ?></div>

                <div class="mb-3">
                  <h6 class="mb-1">Konsep/Tema</h6>
                  <div class="small text-muted mb-2"><?= htmlspecialchars($row['konsep']); ?></div>
                </div>

                <?php if (isset($row['total']) && (int)$row['total'] > 0): ?>
                  <div class="price-box d-flex justify-content-between align-items-center mt-2">
                    <span class="fw-semibold">Total Harga</span>
                    <span class="h5 mb-0">Rp. <?= number_format((int)$row['total'], 0, ",", "."); ?></span>
                  </div>
                <?php endif; ?>
              </div>
            </div>

            <div class="modal-footer d-flex justify-content-between">
              <a href="https://wa.me/628125532111?text=Halo%20ProJasa,%20saya%20tertarik%20dengan%20paket%20<?= urlencode($row['nama']) ?>."
                 target="_blank" rel="noopener"
                 class="btn btn-success">
                <i class="fab fa-whatsapp me-1"></i> Konsultasi via WhatsApp
              </a>
              <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Tutup</button>
            </div>
          </div>
        </div>
      </div>
    <?php endwhile; endif; ?>
  </div>

  <!-- HASIL KERJA KAMI (YouTube) -->
  <div class="row justify-content-center">
    <div class="col-12 text-center">
      <h3 class="fw-bold mb-3">HASIL KERJA KAMI</h3>

      <div class="container px-3 px-md-4">
        <div class="row row-cols-1 row-cols-sm-2 row-cols-lg-3 g-3 justify-content-center">
          <?php if ($videosRes): while ($v = $videosRes->fetch_assoc()):
            $vid   = ytIdFromStored($v['link_yt']);
            $url   = ytWatchUrl($v['link_yt']);
            $thumb = ytThumb($v['link_yt']);
          ?>
          <div class="col">
            <div class="card h-100 shadow-sm video-card">
              <div class="video-thumb-wrap">
                <img src="<?= htmlspecialchars($thumb); ?>" loading="lazy" class="video-thumb" alt="Video thumbnail">
                <button
                  type="button"
                  class="btn btn-light btn-play shadow"
                  data-bs-toggle="modal"
                  data-bs-target="#ytPreviewModal"
                  data-video-id="<?= htmlspecialchars($vid); ?>"
                  aria-label="Putar video">
                  <i class="fas fa-play"></i>
                </button>
              </div>
              <div class="card-body d-flex flex-column">
                <!-- Link YouTube -->
                <a href="<?= htmlspecialchars($url); ?>" target="_blank" rel="noopener" class="text-decoration-none link-dark video-link">
                  <?= htmlspecialchars($url); ?>
                </a>

                <!-- Thumbnail link (baru) -->
                <div class="mt-2 small">
                  <span class="text-muted">Thumbnail:</span>
                  <a href="<?= htmlspecialchars($thumb); ?>" target="_blank" rel="noopener" class="video-link">
                    <?= htmlspecialchars($thumb); ?>
                  </a>
                </div>

                <div class="mt-3 d-flex gap-2 flex-wrap">
                  <?php if ($vid): ?>
                    <button type="button" class="btn btn-sm btn-outline-primary"
                            data-bs-toggle="modal" data-bs-target="#ytPreviewModal"
                            data-video-id="<?= htmlspecialchars($vid); ?>">
                      <i class="fas fa-play me-1"></i> Tonton
                    </button>
                  <?php endif; ?>
                  <a class="btn btn-sm btn-outline-secondary" href="<?= htmlspecialchars($url); ?>" target="_blank" rel="noopener">
                    <i class="fab fa-youtube me-1"></i> Buka di YouTube
                  </a>
                  <button type="button" class="btn btn-sm btn-outline-secondary js-copy" data-copy="<?= htmlspecialchars($url); ?>">
                    <i class="fas fa-copy me-1"></i> Salin Link
                  </button>
                  <!-- Tombol baru: buka & salin thumbnail -->
                  <a class="btn btn-sm btn-outline-secondary" href="<?= htmlspecialchars($thumb); ?>" target="_blank" rel="noopener">
                    <i class="far fa-image me-1"></i> Buka Thumbnail
                  </a>
                  <button type="button" class="btn btn-sm btn-outline-secondary js-copy" data-copy="<?= htmlspecialchars($thumb); ?>">
                    <i class="fas fa-copy me-1"></i> Salin Thumbnail
                  </button>
                </div>
              </div>
            </div>
          </div>
          <?php endwhile; endif; ?>
        </div>
      </div>
    </div>
  </div>
  <!-- /HASIL KERJA KAMI -->
</div> <!-- /container-fluid -->

<?php include_once("partials/footer_portfolio.php"); ?>

<!-- Floating WhatsApp -->
<a
  href="https://wa.me/628125532111"
  class="wa-float"
  target="_blank"
  rel="noopener"
  aria-label="Chat WhatsApp ProJasa (6281138203555)"
  title="Chat via WhatsApp">
  <i class="fab fa-whatsapp"></i>
</a>

<!-- Modal Preview YouTube -->
<div class="modal fade" id="ytPreviewModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content">
      <div class="modal-header py-2">
        <h5 class="modal-title">Preview Video</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Tutup"></button>
      </div>
      <div class="modal-body p-0">
        <div class="ratio ratio-16x9">
          <iframe id="ytPreviewIframe" src="" allowfullscreen referrerpolicy="strict-origin-when-cross-origin"></iframe>
        </div>
      </div>
      <div class="modal-footer py-2">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
      </div>
    </div>
  </div>
</div>

<!-- Bootstrap Bundle -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
  // Inisialisasi carousel
  (function(){
    const el = document.getElementById('portfolioCarousel');
    if (el && window.bootstrap?.Carousel) {
      new bootstrap.Carousel(el, {
        interval: 2500,
        ride: 'carousel',
        pause: false,
        touch: true,
        wrap: true
      });
    }
  })();

  // Animasi berbeda tiap slide
  (function(){
    const mapEffectToClass = {
      'kenburns': 'animate-kenburns',
      'pan-left': 'animate-pan-left',
      'pan-right':'animate-pan-right',
      'tilt':     'animate-tilt',
      'zoom-out': 'animate-zoom-out',
      'fade':     'animate-fade'
    };

    const carousel = document.getElementById('portfolioCarousel');
    if (!carousel) return;

    function clearAllAnimations(){
      carousel.querySelectorAll('.slide-bg').forEach(bg => {
        bg.classList.remove(
          'animate-kenburns','animate-pan-left','animate-pan-right',
          'animate-tilt','animate-zoom-out','animate-fade'
        );
      });
    }

    function applyForActive(){
      const activeItem = carousel.querySelector('.carousel-item.active');
      if (!activeItem) return;
      const effect = activeItem.getAttribute('data-effect') || 'kenburns';
      const cls = mapEffectToClass[effect] || mapEffectToClass['kenburns'];
      const bg = activeItem.querySelector('.slide-bg');
      if (!bg) return;
      clearAllAnimations();
      void bg.offsetWidth; // reflow
      bg.classList.add(cls);
    }

    carousel.addEventListener('slid.bs.carousel', applyForActive);
    window.addEventListener('load', applyForActive);
  })();

  // Modal: set/unset iframe src
  (function(){
    const ytModal = document.getElementById('ytPreviewModal');
    const iframe  = document.getElementById('ytPreviewIframe');
    ytModal?.addEventListener('show.bs.modal', (e) => {
      const btn = e.relatedTarget;
      const id  = btn?.getAttribute('data-video-id');
      iframe.src = id ? `https://www.youtube.com/embed/${id}` : '';
    });
    ytModal?.addEventListener('hidden.bs.modal', () => { iframe.src = ''; });
  })();

  // Copy link (YouTube & Thumbnail)
  document.addEventListener('click', async (e) => {
    const btn = e.target.closest('.js-copy');
    if (!btn) return;
    const val = btn.getAttribute('data-copy') || '';
    try {
      await navigator.clipboard.writeText(val);
      btn.disabled = true;
      const old = btn.innerHTML;
      btn.innerHTML = '<i class="fas fa-check me-1"></i> Disalin';
      setTimeout(() => { btn.innerHTML = old; btn.disabled = false; }, 900);
    } catch (err) {
      alert('Gagal menyalin link.');
    }
  });
</script>
</body>
</html>
