<?php
// edit.php (rewrite)
// Pastikan session & koneksi tersedia
if (session_status() === PHP_SESSION_NONE) session_start();
require_once 'database/koneksi.php'; // sesuaikan path bila perlu

// ======= Basic checks =======
if (!isset($conn) || !($conn instanceof mysqli)) {
    die('Koneksi database belum tersedia.');
}

// cek login
if (!isset($_SESSION['id'])) {
    echo "<script>alert('Silakan login dahulu.'); window.location.href='?page=login';</script>";
    exit;
}

// Ambil ID pengajuan dari GET
if (!isset($_GET['id'])) {
    echo "<script>window.location.href='?page=pengajuan';</script>";
    exit;
}
$id = (int)$_GET['id'];
if ($id <= 0) {
    echo "<script>window.location.href='?page=pengajuan';</script>";
    exit;
}

// ======= Ambil data pengajuan (prepared) =======
$sql = "SELECT p.*, p.id_klien AS id_klien_pengajuan, k.nik AS nik_klien, k.nama_lengkap AS nama_klien
        FROM tb_pengajuan p
        LEFT JOIN tb_klien k ON p.id_klien = k.id
        WHERE p.id = ? LIMIT 1";
$stmt = $conn->prepare($sql);
$stmt->bind_param('i', $id);
$stmt->execute();
$res = $stmt->get_result();
$data = $res ? $res->fetch_assoc() : null;
$stmt->close();

if (!$data) {
    echo "<script>alert('Data pengajuan tidak ditemukan.'); window.location.href='?page=pengajuan';</script>";
    exit;
}

// ======= Permission check: ADMIN boleh, KLIEN hanya miliknya =======
$userLevel = strtoupper((string)($_SESSION['level'] ?? ''));
$userIdKlien = isset($_SESSION['id_klien']) ? (int)$_SESSION['id_klien'] : 0;
$canEdit = false;
if ($userLevel === 'ADMIN') {
    $canEdit = true;
} elseif ($userLevel === 'KLIEN' && (int)$data['id_klien_pengajuan'] === $userIdKlien) {
    $canEdit = true;
}

if (!$canEdit) {
    // forbidden
    echo "<script>alert('Anda tidak memiliki izin mengedit pengajuan ini.'); window.location.href='?page=pengajuan';</script>";
    exit;
}

// ======= Handle POST (submit update) =======
$errors = [];
$success_msg = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit'])) {
    // Ambil input — gunakan trim dan fallback
    $nik_l           = isset($_POST['nik_l']) ? trim($_POST['nik_l']) : null;
    $nama_l          = isset($_POST['nama_l']) ? trim($_POST['nama_l']) : null;
    $nomor_telepon_l = isset($_POST['nomor_telepon_l']) ? trim($_POST['nomor_telepon_l']) : null;

    $tempat_wedding  = isset($_POST['tempat_wedding']) ? trim($_POST['tempat_wedding']) : null;
    $tanggal_wedding = isset($_POST['tanggal_wedding']) && $_POST['tanggal_wedding'] !== '' ? trim($_POST['tanggal_wedding']) : null;

    $konsep    = isset($_POST['konsep']) && $_POST['konsep'] !== '' ? (int)$_POST['konsep'] : null;
    $dekorasi  = isset($_POST['dekorasi']) && $_POST['dekorasi'] !== '' ? (int)$_POST['dekorasi'] : null;

    // Validasi sederhana
    if ($nik_l === null || $nik_l === '') $errors[] = 'NIK harus diisi.';
    if ($nama_l === null || $nama_l === '') $errors[] = 'Nama lengkap harus diisi.';
    // (Tambah validasi lain sesuai kebutuhan)

    // ======= Upload foto KTP (opsional) =======
    $target_dir = __DIR__ . "/uploads/";
    if (!is_dir($target_dir)) {
        @mkdir($target_dir, 0775, true);
    }

    // Keep existing foto path (relatif seperti di DB)
    $foto_l_path = $data['foto_l'] ?? null;

    if (!empty($_FILES['foto_l']['name']) && is_uploaded_file($_FILES['foto_l']['tmp_name'])) {
        $file = $_FILES['foto_l'];
        // Basic validations
        $maxBytes = 3 * 1024 * 1024; // 3MB
        if ($file['size'] > $maxBytes) {
            $errors[] = 'File gambar terlalu besar (maks 3MB).';
        } else {
            $allowedExt = ['jpg','jpeg','png','webp'];
            $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
            if (!in_array($ext, $allowedExt)) {
                $errors[] = 'Ekstensi file tidak diperbolehkan. Gunakan JPG/JPEG/PNG/WEBP.';
            } else {
                // Safe filename
                $baseName = pathinfo($file['name'], PATHINFO_FILENAME);
                $safeBase = preg_replace('/[^a-zA-Z0-9_\-]/', '_', $baseName);
                $newName  = $safeBase . '_' . date('Ymd_His') . '_' . bin2hex(random_bytes(4)) . '.' . $ext;
                $destPath = $target_dir . $newName;

                if (move_uploaded_file($file['tmp_name'], $destPath)) {
                    // Simpan path relatif agar bisa disimpan ke DB (mis: 'uploads/xxx.png')
                    $foto_l_path = 'uploads/' . $newName;

                    // optionally remove old file if exists and is inside uploads folder (safety)
                    if (!empty($data['foto_l']) && strpos($data['foto_l'], 'uploads/') === 0) {
                        $oldAbs = __DIR__ . '/' . $data['foto_l'];
                        if (is_file($oldAbs)) @unlink($oldAbs);
                    }
                } else {
                    $errors[] = 'Gagal memindahkan file gambar.';
                }
            }
        }
    }

    // Jika tidak ada error, lakukan update dengan prepared statement
    if (empty($errors)) {
        $updateSql = "
            UPDATE tb_pengajuan SET
                konsep = ?,
                dekorasi = ?,
                dokumentasi = NULL,
                lighting = NULL,
                sound = NULL,
                band = NULL,
                mc = NULL,
                mua = NULL,

                nik_l = ?,
                nama_l = ?,
                nama_ayah_l = NULL,
                nama_ibu_l = NULL,
                tempat_lahir_l = NULL,
                tanggal_lahir_l = NULL,
                nomor_telepon_l = ?,
                foto_l = ?,

                nik_p = NULL,
                nama_p = NULL,
                nama_ayah_p = NULL,
                nama_ibu_p = NULL,
                tempat_lahir_p = NULL,
                tanggal_lahir_p = NULL,
                nomor_telepon_p = NULL,
                foto_p = NULL,

                tempat_wedding = ?,
                tanggal_wedding = ?
            WHERE id = ?
        ";
        $stmtu = $conn->prepare($updateSql);
        if (!$stmtu) {
            $errors[] = 'Gagal menyiapkan query update: ' . $conn->error;
        } else {
            // Tipe binding:
            // konsep (i|null), dekorasi (i|null), nik_l (s), nama_l (s), nomor_telepon_l (s), foto_l (s|null),
            // tempat_wedding (s|null), tanggal_wedding (s|null), id (i)
            // Untuk nilai null gunakan null variable — mysqli akan mengisi NULL
            // Pastikan urutan sesuai SQL
            // Convert empty strings to null where appropriate
            $nik_l_param = $nik_l !== '' ? $nik_l : null;
            $nama_l_param = $nama_l !== '' ? $nama_l : null;
            $nomor_tel_param = $nomor_telepon_l !== '' ? $nomor_telepon_l : null;
            $foto_param = $foto_l_path !== '' ? $foto_l_path : null;
            $tempat_param = $tempat_wedding !== '' ? $tempat_wedding : null;
            $tanggal_param = $tanggal_wedding !== '' ? $tanggal_wedding : null;

            // bind_param expects types string, build accordingly
            // We'll use 'iissssssi' but because some ints may be null PHP/mysqli handles it.
            // types: konsep(i), dekorasi(i), nik_l(s), nama_l(s), nomor_tel(s), foto(s), tempat(s), tanggal(s), id(i)
            $stmtu->bind_param(
                'iissssssi',
                $konsep,
                $dekorasi,
                $nik_l_param,
                $nama_l_param,
                $nomor_tel_param,
                $foto_param,
                $tempat_param,
                $tanggal_param,
                $id
            );

            if ($stmtu->execute()) {
                $success_msg = 'Pengajuan berhasil diperbarui!';
                // Refresh data variable untuk menampilkan update di form
                $stmtu->close();

                // Ambil kembali data terbaru
                $stmt2 = $conn->prepare("SELECT * FROM tb_pengajuan WHERE id = ? LIMIT 1");
                $stmt2->bind_param('i', $id);
                $stmt2->execute();
                $res2 = $stmt2->get_result();
                $data = $res2->fetch_assoc();
                $stmt2->close();

                // Redirect atau tampil pesan
                echo "<script>alert('Pengajuan berhasil diperbarui!'); window.location.href='?page=pengajuan';</script>";
                exit;
            } else {
                $errors[] = 'Gagal update: ' . $stmtu->error;
                $stmtu->close();
            }
        }
    }
}

// ======= HTML (form) =======
// Anda bisa menempelkan bagian HTML form Anda yang sudah ada.
// Saya akan menampilkan form versi Anda dengan memasukkan value dari $data dan menampilkan error jika ada.
?>
<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid"><div class="row mb-2"><div class="col-sm-6"><h1>Edit Pengajuan</h1></div></div></div>
    </section>

    <form action="" method="POST" enctype="multipart/form-data">
        <section class="content">
            <div class="container-fluid">
                <?php if (!empty($errors)): ?>
                    <div class="alert alert-danger">
                        <?php foreach ($errors as $e) echo '<div>'.htmlspecialchars($e).'</div>'; ?>
                    </div>
                <?php endif; ?>
                <?php if ($success_msg): ?>
                    <div class="alert alert-success"><?= htmlspecialchars($success_msg) ?></div>
                <?php endif; ?>

                <div class="row">
                    <div id="a" class="col-md-12">
                        <div class="card card-primary">
                            <div class="card-header"><h3 class="card-title">Identitas Pemohon</h3></div>

                            <div class="card-body">
                                <div class="row">
                                    <div class="col-6">
                                        <div class="form-group">
                                            <label for="nik_l">NIK</label>
                                            <input type="text" class="form-control" id="nik_l" name="nik_l"
                                                   value="<?= htmlspecialchars($data['nik_l'] ?? '') ?>" placeholder="Masukkan NIK">
                                        </div>

                                        <div class="form-group">
                                            <label for="nama_l">Nama Lengkap</label>
                                            <input type="text" class="form-control" id="nama_l" name="nama_l"
                                                   value="<?= htmlspecialchars($data['nama_l'] ?? '') ?>" placeholder="Masukkan Nama Lengkap">
                                        </div>

                                        <div class="form-group">
                                            <label for="nomor_telepon_l">Nomor Telepon</label>
                                            <input type="text" class="form-control" id="nomor_telepon_l" name="nomor_telepon_l"
                                                   value="<?= htmlspecialchars($data['nomor_telepon_l'] ?? '') ?>" placeholder="Masukkan Nomor Telepon">
                                        </div>

                                        <div class="form-group">
                                            <label for="foto_l">Foto KTP</label>
                                            <div class="input-group">
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input" id="foto_l" name="foto_l" accept="image/*">
                                                    <label id="label_gambar_l" class="custom-file-label" for="foto_l">Pilih gambar</label>
                                                </div>
                                            </div>
                                        </div>

                                        <hr>

                                        <div class="form-group">
                                            <label for="tempat_wedding">Area Pengurusan</label>
                                            <input type="text" class="form-control" id="tempat_wedding" name="tempat_wedding"
                                                   value="<?= htmlspecialchars($data['tempat_wedding'] ?? '') ?>" placeholder="Masukkan Area Pengurusan">
                                        </div>

                                        <div class="form-group">
                                            <label for="tanggal_wedding">Tanggal Pengurusan</label>
                                            <input type="date" class="form-control" id="tanggal_wedding" name="tanggal_wedding"
                                                   value="<?= htmlspecialchars($data['tanggal_wedding'] ?? '') ?>">
                                        </div>
                                    </div>

                                    <div class="col-6">
                                        <div class="form-group text-center">
                                            <label class="h5">Preview Foto KTP</label>
                                            <div class="d-flex justify-content-center mt-3">
                                                <img id="preview-foto-l"
                                                     src="<?= htmlspecialchars($data['foto_l'] ?: 'assets/img/pp.png') ?>"
                                                     class="img-thumbnail img-fluid"
                                                     style="width: 300px; height: 400px; object-fit: cover;">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="card-footer d-flex justify-content-end">
                                <button type="reset" class="btn btn-secondary mr-2">Reset</button>
                                <button id="next-btn" type="button" class="btn btn-primary">Next</button>
                            </div>
                        </div>
                    </div>

                    <div id="b" class="col-12 d-none">
                        <div class="row">
                            <div class="col-4">
                                <div class="card card-primary">
                                    <div class="card-header"><h3 class="card-title">Pilih Jasa</h3></div>
                                    <div class="card-body">
                                        <!-- Konsep -->
                                        <div class="form-group">
                                            <?php $rsKonsep = $conn->query("SELECT * FROM tb_konsep"); ?>
                                            <label>Konsep / Tema</label>
                                            <select name="konsep" class="form-control select2" onchange="berubah(this, 'konsep', false)">
                                                <option value="">Pilih Tema</option>
                                                <?php while ($rowK = $rsKonsep->fetch_assoc()) : 
                                                    $selected = ((int)$data['konsep'] === (int)$rowK['id']) ? 'selected' : '';
                                                ?>
                                                    <option <?= $selected ?>
                                                        data-id="<?= (int)$rowK['id'] ?>"
                                                        data-nama="<?= htmlspecialchars($rowK['nama']) ?>"
                                                        data-harga="0"
                                                        data-detail="<?= htmlspecialchars($rowK['detail']) ?>"
                                                        value="<?= (int)$rowK['id'] ?>">
                                                        <?= htmlspecialchars($rowK['nama']) ?>
                                                    </option>
                                                <?php endwhile; ?>
                                            </select>
                                        </div>

                                        <!-- Dekorasi -->
                                        <div class="form-group">
                                            <?php $rsDekor = $conn->query("SELECT * FROM tb_produksi WHERE jenis='DEKORASI'"); ?>
                                            <label>Dekorasi</label>
                                            <select name="dekorasi" class="form-control select2" onchange="berubah(this, 'produksi', 'dekorasi')">
                                                <option value="">Pilih Dekorasi</option>
                                                <?php while ($rowD = $rsDekor->fetch_assoc()) :
                                                    $selected = ((int)$data['dekorasi'] === (int)$rowD['id']) ? 'selected' : '';
                                                ?>
                                                    <option <?= $selected ?>
                                                        data-id="<?= (int)$rowD['id'] ?>"
                                                        data-nama="<?= htmlspecialchars($rowD['nama']) ?>"
                                                        data-harga="<?= (int)$rowD['harga'] ?>"
                                                        data-detail="<?= htmlspecialchars($rowD['detail']) ?>"
                                                        value="<?= (int)$rowD['id'] ?>">
                                                        <?= htmlspecialchars($rowD['nama']) ?> | Rp. <?= number_format($rowD['harga'], 0, ',', '.') ?>
                                                    </option>
                                                <?php endwhile; ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="card-footer d-flex justify-content-end">
                                        <button id="back" type="button" class="btn btn-secondary mr-2">Back</button>
                                        <button type="submit" name="submit" class="btn btn-primary">Simpan</button>
                                    </div>
                                </div>
                            </div>

                            <div class="col-8">
                                <div class="card mb-3" style="width: 100%; height: 495px;">
                                    <div class="card-body d-flex">
                                        <div id="carouselExampleControls" class="carousel slide float-left mr-3" data-ride="carousel">
                                            <div class="carousel-inner" style="width: 400px; height: 450px;"></div>
                                            <button class="carousel-control-prev" type="button" data-target="#carouselExampleControls" data-slide="prev">
                                                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                                <span class="sr-only">Previous</span>
                                            </button>
                                            <button class="carousel-control-next" type="button" data-target="#carouselExampleControls" data-slide="next">
                                                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                                <span class="sr-only">Next</span>
                                            </button>
                                        </div>

                                        <div>
                                            <h3 id="nama_master"></h3>
                                            <p id="detail_master"></p>
                                        </div>
                                    </div>
                                </div>
                                <h1 id="total_biaya">Total Biaya: Rp. 0</h1>
                            </div>
                        </div>
                    </div>

                </div> <!-- /.row -->
            </div> <!-- /.container-fluid -->
        </section>
    </form>
</div>

<script>
    // jQuery handlers (pastikan jQuery loaded)
    $("#foto_l").on('change', function() {
        const image = this.files && this.files[0];
        if (!image) return;
        const oFReader = new FileReader();
        oFReader.readAsDataURL(image);
        oFReader.onload = function(e) {
            $("#preview-foto-l").attr('src', e.target.result);
            $("#label_gambar_l").text(image.name);
        }
    });

    // Step navigation
    document.querySelector('#next-btn').addEventListener('click', function() {
        document.querySelector('#a').classList.toggle('d-none');
        document.querySelector('#b').classList.toggle('d-none');
    });
    document.querySelector('#back').addEventListener('click', function() {
        document.querySelector('#b').classList.toggle('d-none');
        document.querySelector('#a').classList.toggle('d-none');
    });

    // initialize select2 if present
    if (typeof $.fn.select2 !== 'undefined') {
        $('.select2').select2({ theme: 'bootstrap4' });
    }

    // gambar & total are generated server-side earlier in original code
    let gambar = {};
    let total_biaya = {};

    function berubah(element, jenis, hargaKey) {
        const opt = element.options[element.selectedIndex];
        const id = opt.getAttribute('data-id');
        const nama = opt.getAttribute('data-nama') || '';
        const detail = opt.getAttribute('data-detail') || '';
        const harga = parseInt((opt.getAttribute('data-harga') || '0').toString().replace(/[^0-9]/g, '')) || 0;

        document.querySelector("#nama_master").textContent = nama;
        document.querySelector("#detail_master").textContent = detail;

        const container = document.querySelector(".carousel-inner");
        container.innerHTML = "";
        // server-side original code populated JS variable 'gambar'; if not, nothing to show
        if (typeof gambar[jenis] !== 'undefined' && gambar[jenis][id] && gambar[jenis][id].length) {
            container.insertAdjacentHTML('beforeend', `
                <div class="carousel-item active">
                    <img width="400" height="450" style="object-fit: cover;" src="${gambar[jenis][id][0]['gambar']}">
                </div>
            `);
            for (let i = 1; i < gambar[jenis][id].length; i++) {
                container.insertAdjacentHTML('beforeend', `
                    <div class="carousel-item">
                        <img width="400" height="450" style="object-fit: cover;" src="${gambar[jenis][id][i]['gambar']}">
                    </div>
                `);
            }
        }

        if (hargaKey) {
            total_biaya[hargaKey] = harga;
        }
        let total = 0;
        for (const k in total_biaya) { total += parseInt(total_biaya[k] || 0); }
        document.querySelector("#total_biaya").textContent = formatRupiah(total.toString(), "Rp. ");
    }

    function formatRupiah(angka, prefix) {
        var number_string = (angka || '').replace(/[^,\d]/g, '').toString(),
            split = number_string.split(','),
            sisa = split[0].length % 3,
            rupiah = split[0].substr(0, sisa),
            ribuan = split[0].substr(sisa).match(/\d{3}/gi);

        if (ribuan) {
            var separator = sisa ? '.' : '';
            rupiah += separator + ribuan.join('.');
        }

        rupiah = split[1] != undefined ? rupiah + ',' + split[1] : rupiah;
        return prefix == undefined ? rupiah : (rupiah ? prefix + ' ' + rupiah : '');
    }
</script>
