<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">

                    <div class="card mt-3">
                        <div class="card-header">
                            <div class="row">
                                <div class="col d-flex align-items-center">
                                    <h4 class="font-weight-bold">Laporan Grafik Layanan</h4>
                                </div>
                                <div class="col-auto">
                                    <form action="" method="POST">
                                        <div class="row">
                                            <div class="col-2">
                                                <div class="row">
                                                    <div class="col-12 py-2 mb-3">Jenis</div>
                                                    <div class="col-12 py-2">Tahun</div>
                                                </div>
                                            </div>
                                            <div class="col">
                                                <div class="row">
                                                    <div class="col-12 mb-3">
                                                        <select name="jenis" id="jenis" class="form-control">
                                                            <?php
                                                            $jenisPost = isset($_POST['filter']) ? $_POST['jenis'] : '';
                                                            ?>
                                                            <option value="PERIZINAN"  <?= $jenisPost === 'PERIZINAN'  ? 'selected' : '' ?>>PERIZINAN</option>
                                                            <option value="MAN POWER" <?= $jenisPost === 'MAN POWER' ? 'selected' : '' ?>>MAN POWER</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-12">
                                                        <input type="number" class="form-control" name="tahun" value="<?= isset($_POST['filter']) ? (int)$_POST['tahun'] : (int)date('Y') ?>">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-auto d-flex align-items-end py-1">
                                                <button type="submit" name="filter" class="btn btn-secondary">Filter</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <div class="card-body">
                            <div class="chart">
                                <canvas id="barChart" style="min-height: 250px; height: 550px; max-height: 550px; max-width: 100%;"></canvas>
                            </div>
                        </div>

                        <div class="card-footer">
                            <?php
                            $tahunCetak = isset($_POST['filter']) ? (int)$_POST['tahun'] : (int)date('Y');
                            $jenisCetak = isset($_POST['filter']) ? $_POST['jenis'] : 'PERIZINAN';
                            ?>
                            <a href="laporan/produksi.php?tahun=<?= $tahunCetak ?>&jenis=<?= urlencode($jenisCetak) ?>" class="btn btn-primary float-right" target="_blank">Cetak</a>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </section>
</div>

<?php
// ======================= PHP DATA SOURCE ==========================
$tahun = isset($_POST['filter']) ? (int)$_POST['tahun'] : (int)date('Y');
$jenis = isset($_POST['filter']) ? $_POST['jenis'] : 'PERIZINAN';

// Pemetaan jenis -> kolom FK di tb_pengajuan
$fkColumn = ($jenis === 'MAN POWER') ? 'dokumentasi' : 'dekorasi';

// Ambil daftar layanan (tb_produksi) untuk jenis terpilih
$mapProduk = [];         // id_produksi => nama
$idsForIN  = [];         // untuk filter IN()

$stmt = $conn->prepare("SELECT id, nama FROM tb_produksi WHERE jenis = ? ORDER BY nama ASC");
$stmt->bind_param("s", $jenis);
$stmt->execute();
$resProduk = $stmt->get_result();
while ($r = $resProduk->fetch_assoc()) {
    $mapProduk[(int)$r['id']] = $r['nama'];
    $idsForIN[] = (int)$r['id'];
}
$stmt->close();

// Siapkan matriks data 12 bulan nol per layanan
$dataProduk = []; // id => [1..12] => count
foreach ($mapProduk as $pid => $nama) {
    $dataProduk[$pid] = array_fill(1, 12, 0);
}

if (!empty($idsForIN)) {
    // Satu query agregasi: jumlah per bulan per layanan
    $inList = implode(',', array_map('intval', $idsForIN));
    $sql = "
        SELECT p.$fkColumn AS id_item, MONTH(p.tanggal_pengajuan) AS m, COUNT(*) AS jml
        FROM tb_pengajuan p
        WHERE p.status='Disetujui'
          AND YEAR(p.tanggal_pengajuan) = {$tahun}
          AND p.$fkColumn IN ($inList)
        GROUP BY p.$fkColumn, MONTH(p.tanggal_pengajuan)
    ";
    $resAgg = $conn->query($sql);
    if ($resAgg) {
        while ($row = $resAgg->fetch_assoc()) {
            $pid = (int)$row['id_item'];
            $m   = (int)$row['m'];
            $cnt = (int)$row['jml'];
            if (isset($dataProduk[$pid]) && $m>=1 && $m<=12) {
                $dataProduk[$pid][$m] = $cnt;
            }
        }
    }
}

// Susun datasets untuk Chart.js
$datasets = [];
foreach ($mapProduk as $pid => $nama) {
    $datasets[] = [
        'label' => $nama,
        'data'  => array_values($dataProduk[$pid])
    ];
}

$labelsBulan = ['January','February','March','April','May','June','July','Agustus','September','Oktober','November','Desember'];
?>

<script>
$(function() {
    // ====== Data dari PHP ======
    var labelsBulan = <?= json_encode($labelsBulan) ?>;
    var phpDatasets = <?= json_encode($datasets, JSON_UNESCAPED_UNICODE) ?>;

    // Utility warna (Chart.js v2 friendly)
    function randColor(alpha) {
        alpha = alpha || 0.85;
        var r = Math.floor(Math.random()*200)+30;
        var g = Math.floor(Math.random()*200)+30;
        var b = Math.floor(Math.random()*200)+30;
        return {
            bg: 'rgba('+r+','+g+','+b+','+alpha+')',
            bd: 'rgba('+Math.max(0,r-25)+','+Math.max(0,g-25)+','+Math.max(0,b-25)+',1)'
        };
    }

    var chartDatasets = phpDatasets.map(function(ds){
        var c = randColor(0.85);
        return {
            label: ds.label,
            data: ds.data.map(function(v){ return parseInt(v||0); }),
            backgroundColor: c.bg,
            borderColor: c.bd,
            borderWidth: 1.5
        };
    });

    var areaChartData = {
        labels: labelsBulan,
        datasets: chartDatasets
    };

    var barChartOptions = {
        responsive: true,
        maintainAspectRatio: false,
        datasetFill: false,
        legend: { display: true, position: 'bottom' },
        tooltips: {
            callbacks: {
                label: function(item, data) {
                    var label = data.datasets[item.datasetIndex].label || '';
                    var val = item.yLabel;
                    return label + ': ' + val;
                }
            }
        },
        scales: {
            xAxes: [{ gridLines: { display: false } }],
            yAxes: [{
                ticks: {
                    beginAtZero: true,
                    callback: function(value) { if (value % 1 === 0) return value; }
                },
                gridLines: { display: false }
            }]
        }
    };

    var barChartCanvas = $('#barChart').get(0).getContext('2d');
    var barChartData   = $.extend(true, {}, areaChartData);

    new Chart(barChartCanvas, {
        type: 'bar',
        data: barChartData,
        options: barChartOptions
    });
});
</script>
