<?php
include_once("../database/koneksi.php");
include_once("../utils/tanggal.php");

// Helpers
function param($key, $default = '') {
  if (isset($_POST[$key])) return trim($_POST[$key]);
  if (isset($_GET[$key]))  return trim($_GET[$key]);
  return $default;
}
function indoDateYmd($ymd, $bulanIndo) {
  if (!$ymd || $ymd === '0000-00-00') return '-';
  $parts = explode('-', $ymd);
  if (count($parts) !== 3) return $ymd;
  [$y,$m,$d] = $parts;
  $m = (int)$m; $d = ltrim($d,'0');
  return $d . " " . ($bulanIndo[$m-1] ?? $m) . " " . $y;
}

// Filters
$status  = param('status', '');
$dari    = param('dari',   '');
$sampai  = param('sampai', '');

// Escape dasar
$esc = fn($v) => $conn->real_escape_string($v ?? '');

// Query
$sql = "
  SELECT 
    tb_pembayaran.keterangan AS keterangan_pembayaran,
    tb_pembayaran.status     AS status_pembayaran,
    tb_pembayaran.tanggal    AS tanggal_pembayaran,
    tb_pembayaran.tanggal_verifikasi,
    tb_bank.nama             AS nama_bank,
    tb_bank.atas_nama,
    tb_bank.no_rek,
    tb_klien.nama_lengkap,
    tb_anggaran.anggaran_tambahan,
    (SELECT harga FROM tb_produksi  WHERE id=tb_pengajuan.dekorasi)    AS harga_dekorasi,
    (SELECT harga FROM tb_produksi  WHERE id=tb_pengajuan.dokumentasi) AS harga_dokumentasi,
    (SELECT harga FROM tb_equipment WHERE id=tb_pengajuan.lighting)    AS harga_lighting,
    (SELECT harga FROM tb_equipment WHERE id=tb_pengajuan.sound)       AS harga_sound,
    (SELECT harga FROM tb_talent    WHERE id=tb_pengajuan.band)        AS harga_band,
    (SELECT harga FROM tb_talent    WHERE id=tb_pengajuan.mc)          AS harga_mc,
    (SELECT harga FROM tb_talent    WHERE id=tb_pengajuan.mua)         AS harga_mua
  FROM tb_pengajuan
  INNER JOIN tb_klien     ON tb_pengajuan.id_klien = tb_klien.id
  INNER JOIN tb_anggaran  ON tb_pengajuan.id       = tb_anggaran.id_pengajuan
  LEFT  JOIN tb_pembayaran ON tb_anggaran.id       = tb_pembayaran.id_anggaran
  INNER JOIN tb_bank      ON tb_bank.id            = tb_pembayaran.id_bank
  WHERE 1=1
";
if ($status !== '') {
  $sql .= " AND tb_pembayaran.status LIKE '%" . $esc($status) . "%'";
}
if ($dari !== '' && $sampai !== '') {
  $sql .= " AND DATE(tb_pembayaran.tanggal) >= '" . $esc($dari) . "' 
            AND DATE(tb_pembayaran.tanggal) <= '" . $esc($sampai) . "'";
}
$sql .= " ORDER BY tb_pembayaran.tanggal DESC";
$result = $conn->query($sql);
?>
<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Laporan Pembayaran</title>
  <link href="bootstrap.min.css" rel="stylesheet">
  <style>
    /* --- Global fixes to prevent horizontal overflow --- */
    html, body { width: 100%; }
    body { overflow-x: hidden; }
    img { max-width: 100%; height: auto; }

    :root{ --td-pad-y:.5rem; --td-pad-x:.5rem; }

    .table-responsive { width: 100%; max-width: 100%; border-radius: .5rem; }
    .table thead th { position: sticky; top: 0; z-index: 1; background: #f8f9fa; }
    .table td, .table th { vertical-align: middle; padding: var(--td-pad-y) var(--td-pad-x); }
    .small-td { white-space: nowrap; }
    .wrap { white-space: normal; word-wrap: break-word; overflow-wrap: anywhere; }
    .break-all { word-break: break-all; }

    /* Grid gutter small to avoid negative overflow from .row */
    .gx-2 { --bs-gutter-x: .5rem; }

    /* Stacked card mode for very small screens */
    @media (max-width: 576px){
      .table thead { display: none; }
      .table tbody tr { display: block; margin: .75rem 0; border: 1px solid rgba(0,0,0,.08); border-radius: .5rem; overflow: hidden; }
      .table tbody td { display: grid; grid-template-columns: 42% 58%; align-items: start; }
      .table tbody td::before { content: attr(data-label); font-weight: 600; padding-right: .5rem; }
      .small-td { white-space: normal; }
      /* Pastikan tidak ada padding berlebih yang bikin melebar */
      .table-bordered> :not(caption)>* { border-width: 0; }
    }

    /* Print styles */
    @media print {
      @page { size: A4 landscape; margin: 12mm; }
      body { -webkit-print-color-adjust: exact; print-color-adjust: exact; overflow: visible !important; }
      .no-print, .container-fluid { width: 100% !important; padding: 0 !important; margin: 0 !important; }
      .table-responsive { overflow: visible !important; }
      .table thead th { background: #e9ecef !important; }
    }
  </style>
</head>
<body>

  <div class="container-fluid px-3 px-md-4">
    <?php include('kop.php'); ?>
    <hr class="my-3">

    <section id="filter" class="my-3">
      <div class="row gx-2 gy-1">
        <div class="col-12 col-md-6 col-lg-4">
          <div class="d-flex flex-wrap">
            <div class="me-2 fw-semibold">Laporan</div><div>: Data Pembayaran</div>
          </div>
        </div>
        <div class="col-12 col-md-6 col-lg-4">
          <div class="d-flex flex-wrap">
            <div class="me-2 fw-semibold">Status</div><div>: <?= ($status === '') ? 'Semua' : htmlspecialchars($status); ?></div>
          </div>
        </div>
        <?php if ($dari !== '' && $sampai !== ''): ?>
        <div class="col-12 col-md-6 col-lg-4">
          <div class="d-flex flex-wrap">
            <div class="me-2 fw-semibold">Dari</div><div>: <?= indoDateYmd($dari, $BULAN_DALAM_INDONESIA); ?></div>
          </div>
        </div>
        <div class="col-12 col-md-6 col-lg-4">
          <div class="d-flex flex-wrap">
            <div class="me-2 fw-semibold">Sampai</div><div>: <?= indoDateYmd($sampai, $BULAN_DALAM_INDONESIA); ?></div>
          </div>
        </div>
        <?php endif; ?>
      </div>
    </section>

    <section id="data" class="mb-3">
      <div class="table-responsive shadow-sm">
        <table class="table table-bordered table-striped align-middle m-0">
          <thead class="text-center">
            <tr>
              <th class="small-td">No</th>
              <th class="small-td">Tanggal Pembayaran</th>
              <th>Nama Klien</th>
              <th>Bank</th>
              <th>Atas Nama</th>
              <th class="small-td">Nomor Rekening</th>
              <th class="small-td">Total Pembayaran</th>
              <th class="small-td">Status</th>
              <th>Keterangan</th>
              <th class="small-td">Tanggal Verifikasi</th>
            </tr>
          </thead>
          <tbody>
            <?php
            $no = 1; $grandTotal = 0;
            while ($row = $result->fetch_assoc()):
              $tglBayarYmd = $row['tanggal_pembayaran'] ? explode(' ', $row['tanggal_pembayaran'])[0] : null;
              $tglVerifYmd = $row['tanggal_verifikasi'] ? explode(' ', $row['tanggal_verifikasi'])[0] : null;

              $total =
                (int)($row['anggaran_tambahan'] ?? 0) +
                (int)($row['harga_dekorasi'] ?? 0) +
                (int)($row['harga_dokumentasi'] ?? 0) +
                (int)($row['harga_lighting'] ?? 0) +
                (int)($row['harga_sound'] ?? 0) +
                (int)($row['harga_band'] ?? 0) +
                (int)($row['harga_mc'] ?? 0) +
                (int)($row['harga_mua'] ?? 0);

              $grandTotal += $total;
            ?>
            <tr>
              <td class="text-center small-td" data-label="No"><?= $no++; ?></td>
              <td class="text-center small-td" data-label="Tanggal Pembayaran"><?= indoDateYmd($tglBayarYmd, $BULAN_DALAM_INDONESIA); ?></td>
              <td class="text-center" data-label="Nama Klien"><?= htmlspecialchars($row['nama_lengkap']); ?></td>
              <td class="text-center" data-label="Bank"><?= htmlspecialchars($row['nama_bank']); ?></td>
              <td class="text-center" data-label="Atas Nama"><?= htmlspecialchars($row['atas_nama']); ?></td>
              <td class="text-center small-td break-all" data-label="Nomor Rekening"><?= htmlspecialchars($row['no_rek']); ?></td>
              <td class="text-end small-td" data-label="Total Pembayaran">Rp <?= number_format($total, 0, ",", "."); ?></td>
              <td class="text-center small-td" data-label="Status"><?= htmlspecialchars($row['status_pembayaran']); ?></td>
              <td class="wrap" data-label="Keterangan"><?= nl2br(htmlspecialchars($row['keterangan_pembayaran'] ?? '')); ?></td>
              <td class="text-center small-td" data-label="Tanggal Verifikasi"><?= indoDateYmd($tglVerifYmd, $BULAN_DALAM_INDONESIA); ?></td>
            </tr>
            <?php endwhile; ?>
          </tbody>
          <tfoot>
            <tr>
              <th colspan="6" class="text-end">Grand Total</th>
              <th class="text-end">Rp <?= number_format($grandTotal, 0, ",", "."); ?></th>
              <th colspan="3"></th>
            </tr>
          </tfoot>
        </table>
      </div>
    </section>

    <?php include_once("signature.php"); ?>

    <div class="no-print text-center my-3">
      <button class="btn btn-primary" onclick="window.print()">Cetak</button>
    </div>
  </div>

  <script>
    // Jika ingin auto-print seperti semula, uncomment:
    // window.print();
  </script>
</body>
</html>
