/* charts-dashboard.js */
(function () {
  'use strict';

  if (!window.Chart) return; // pastikan Chart.js sudah ada

  // -----------------------------
  // WARNA KONSISTEN BERDASARKAN LABEL
  // -----------------------------
  function colorFromString(str, alpha) {
    alpha = (typeof alpha === 'number') ? alpha : 0.85;

    // djb2 hash → stabil untuk setiap label
    let hash = 5381;
    const s = String(str);
    for (let i = 0; i < s.length; i++) {
      hash = ((hash << 5) + hash) + s.charCodeAt(i);
    }

    const r = (hash >> 16) & 255;
    const g = (hash >> 8)  & 255;
    const b = hash & 255;

    const clamp = v => Math.max(40, Math.min(215, v));
    const rr = clamp(r), gg = clamp(g), bb = clamp(b);

    const darker = v => Math.max(0, v - 28);

    return {
      bg: `rgba(${rr},${gg},${bb},${alpha})`,
      bd: `rgba(${darker(rr)},${darker(gg)},${darker(bb)},1)`
    };
  }

  // -----------------------------
  // PIE STATUS
  // -----------------------------
  (function initPieStatus() {
    var pieEl = document.getElementById('pieStatus');
    if (!pieEl) return;

    // Data bisa dioverride via global:
    // window.PIE_STATUS_LABELS = [...]; window.PIE_STATUS_DATA = [...]
    var labels = (window.PIE_STATUS_LABELS && window.PIE_STATUS_LABELS.length)
      ? window.PIE_STATUS_LABELS
      : ['Pending','Disetujui','Ditolak'];

    var values = (window.PIE_STATUS_DATA && window.PIE_STATUS_DATA.length)
      ? window.PIE_STATUS_DATA
      : [1, 1, 0];

    var bg = labels.map(l => colorFromString(l, 0.9).bg);
    var bd = labels.map(l => colorFromString(l, 0.9).bd);

    new Chart(pieEl.getContext('2d'), {
      type: 'doughnut',
      data: {
        labels: labels,
        datasets: [{
          data: values.map(v => parseInt(v || 0, 10)),
          backgroundColor: bg,
          borderColor: bd,
          borderWidth: 1
        }]
      },
      options: {
        responsive: true,
        maintainAspectRatio: false,
        cutoutPercentage: 55,
        legend: { position: 'bottom' },
        tooltips: { mode: 'nearest', intersect: false }
      }
    });
  })();

  // -----------------------------
  // BAR KONSEP PER BULAN
  // -----------------------------
  (function initBarKonsep() {
    var barEl = document.getElementById('barKonsep');
    if (!barEl) return;

    var labelsBulan = [
      "January","February","March","April","May","June",
      "July","Agustus","September","Oktober","November","Desember"
    ];

    // Bisa dioverride via global, kalau tidak ada pakai contoh default
    var phpDatasets = Array.isArray(window.BAR_KONSEP_DATASETS)
      ? window.BAR_KONSEP_DATASETS
      : [
          {"label":"As Built Drawing","data":[0,0,0,0,0,0,0,0,0,0,0,0]},
          {"label":"PBG - SLF","data":[0,0,0,0,0,0,0,0,1,0,0,0]},
          {"label":"Pengetesan Bangunan","data":[0,0,0,0,0,0,0,0,0,0,0,0]},
          {"label":"UKL - UPL","data":[0,0,0,0,0,0,0,0,0,0,0,0]}
        ];

    var datasets = phpDatasets.map(function (d) {
      var c = colorFromString(d.label, 0.85);
      return {
        label: d.label,
        data: (d.data || []).map(v => parseInt(v || 0, 10)),
        backgroundColor: c.bg,
        borderColor: c.bd,
        borderWidth: 1.5,
        maxBarThickness: 42
      };
    });

    new Chart(barEl.getContext('2d'), {
      type: 'bar',
      data: { labels: labelsBulan, datasets: datasets },
      options: {
        responsive: true,
        maintainAspectRatio: false,
        legend: { position: 'bottom' },
        tooltips: { intersect: false, mode: 'index' },
        scales: {
          xAxes: [{ gridLines: { display: false } }],
          yAxes: [{
            ticks: {
              beginAtZero: true,
              callback: function (v) { if (v % 1 === 0) return v; }
            },
            gridLines: { display: false }
          }]
        },
        animation: { duration: 700, easing: 'easeOutQuart' }
      }
    });
  })();

})();
