<?php
// Pastikan koneksi sudah di-include sebelum file ini dipanggil
// include_once("../database/koneksi.php");

if (isset($_POST['submit'])) {
    // Ambil input (yang dipakai saja)
    $nama       = trim($_POST['nama'] ?? '');
    $konsep     = trim($_POST['konsep'] ?? '');
    $keterangan = trim($_POST['keterangan'] ?? '');

    // Validasi sederhana server-side
    $errors = [];
    if ($nama === '')       $errors[] = 'Nama jasa wajib diisi.';
    if ($konsep === '' || !ctype_digit($konsep)) $errors[] = 'Perizinan/Jasa wajib dipilih.';
    // keterangan boleh kosong

    // Upload gambar (opsional)
    $target_file = null;
    if (!empty($_FILES['gambar']['name'])) {
        $target_dir = __DIR__ . "/uploads/"; // simpan fisik di folder ini
        if (!is_dir($target_dir)) {
            @mkdir($target_dir, 0755, true);
        }

        $ext = strtolower(pathinfo($_FILES['gambar']['name'], PATHINFO_EXTENSION));
        $allowed = ['jpg','jpeg','png','gif','webp'];

        if (!in_array($ext, $allowed)) {
            $errors[] = 'Format gambar tidak didukung. Gunakan JPG/PNG/GIF/WEBP.';
        } else {
            // nama file unik & aman
            try {
                $newName = 'paket_' . date('Ymd_His') . '_' . bin2hex(random_bytes(4)) . '.' . $ext;
            } catch (\Throwable $e) {
                // fallback jika random_bytes tidak tersedia
                $newName = 'paket_' . date('Ymd_His') . '_' . substr(md5(uniqid('', true)), 0, 8) . '.' . $ext;
            }

            $absFile = $target_dir . $newName;         // path absolut
            $relFile = "uploads/" . $newName;          // path relatif untuk disimpan di DB

            if (!move_uploaded_file($_FILES['gambar']['tmp_name'], $absFile)) {
                $errors[] = 'Upload gambar gagal. Silakan coba lagi atau pilih file lain.';
            } else {
                $target_file = $relFile;
            }
        }
    }

    if (empty($errors)) {
        // Insert pakai prepared statement
        if ($target_file) {
            $sql = "INSERT INTO tb_paket_wedding (nama, konsep, keterangan, gambar) VALUES (?, ?, ?, ?)";
        } else {
            $sql = "INSERT INTO tb_paket_wedding (nama, konsep, keterangan) VALUES (?, ?, ?)";
        }

        if ($stmt = $conn->prepare($sql)) {
            if ($target_file) {
                $stmt->bind_param("siss", $nama, $konsep, $keterangan, $target_file);
            } else {
                $stmt->bind_param("sis", $nama, $konsep, $keterangan);
            }

            if ($stmt->execute()) {
                echo "<script>alert('Data PAKET JASA KAMI berhasil ditambahkan!');</script>";
                echo "<script>window.location.href='?page=paket_wedding';</script>";
                exit;
            } else {
                echo "<script>alert('Gagal menyimpan data: ".addslashes($stmt->error)."');</script>";
            }
            $stmt->close();
        } else {
            echo "<script>alert('Gagal menyiapkan query: ".addslashes($conn->error)."');</script>";
        }
    } else {
        // tampilkan error
        echo "<script>alert('".addslashes(implode("\\n", $errors))."');</script>";
    }
}
?>

<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <div class="container-fluid">
      <div class="row mb-2 justify-content-center">
        <div class="col-sm-8 col-md-6 text-center">
          <h1>Tambah Data PAKET JASA KAMI</h1>
        </div>
      </div>
    </div>
  </section>

  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">
      <div class="row justify-content-center">
        <div class="col-md-7 col-lg-6">
          <div class="card card-primary shadow">
            <form action="" method="POST" enctype="multipart/form-data">
              <div class="card-body">
                <!-- Nama -->
                <div class="form-group">
                  <label for="nama">Nama Jasa</label>
                  <input type="text" class="form-control" id="nama" name="nama" placeholder="Masukkan nama jasa" required>
                </div>

                <!-- Konsep -->
                <div class="form-group">
                  <?php $resultKonsep = $conn->query("SELECT id, nama FROM tb_konsep ORDER BY nama ASC"); ?>
                  <label for="konsep">Perizinan</label>
                  <select id="konsep" name="konsep" class="form-control select2" required>
                    <option value="" selected disabled>Pilih Jasa</option>
                    <?php if ($resultKonsep): while ($row = $resultKonsep->fetch_assoc()): ?>
                      <option value="<?= (int)$row['id']; ?>"><?= htmlspecialchars($row['nama']); ?></option>
                    <?php endwhile; endif; ?>
                  </select>
                </div>

                <!-- Keterangan -->
                <div class="form-group">
                  <label for="keterangan">Keterangan</label>
                  <textarea name="keterangan" id="keterangan" class="form-control" rows="4" placeholder="Deskripsi singkat jasa"></textarea>
                </div>

                <!-- Gambar -->
                <div class="form-group">
                  <label for="gambar">Foto (opsional)</label>
                  <div class="input-group">
                    <div class="custom-file">
                      <input type="file" class="custom-file-input" id="gambar" name="gambar" accept=".jpg,.jpeg,.png,.gif,.webp">
                      <label class="custom-file-label" for="gambar">Pilih foto</label>
                    </div>
                  </div>
                  <small class="text-muted d-block mt-1">Format: JPG/PNG/GIF/WEBP. Maksimal sesuai konfigurasi server.</small>
                </div>
              </div>

              <div class="card-footer d-flex justify-content-end">
                <button type="submit" name="submit" class="btn btn-primary">
                  <i class="fas fa-save mr-1"></i> Submit
                </button>
              </div>
            </form>
          </div>
        </div>
      </div>
  </section>
  <!-- /.content -->
</div>

<script>
  // Tampilkan nama file terpilih di label custom-file (AdminLTE/BS4)
  document.addEventListener('change', function (e) {
    if (e.target && e.target.matches('.custom-file-input')) {
      const input = e.target;
      const label = input.nextElementSibling;
      const fileName = input.files && input.files.length ? input.files[0].name : 'Pilih foto';
      if (label && label.classList.contains('custom-file-label')) {
        label.textContent = fileName;
      }
    }
  });
</script>
