<?php
// Pastikan sudah include koneksi & session jika perlu
// include_once("../database/koneksi.php");

function extractYouTubeId(string $url): ?string {
    $url = trim($url);

    // Jika user langsung memasukkan 11-char ID, terima saja
    if (preg_match('/^[a-zA-Z0-9_-]{11}$/', $url)) {
        return $url;
    }

    // Normalisasi: parse URL
    $parts = @parse_url($url);
    if (!$parts || !isset($parts['host'])) {
        return null;
    }

    $host = strtolower($parts['host']);
    $path = $parts['path'] ?? '';
    $query = $parts['query'] ?? '';

    // 1) youtube.com/watch?v=VIDEOID
    if (strpos($host, 'youtube.com') !== false) {
        parse_str($query, $q);
        if (!empty($q['v']) && preg_match('/^[a-zA-Z0-9_-]{11}$/', $q['v'])) {
            return $q['v'];
        }
        // 2) youtube.com/embed/VIDEOID
        if (preg_match('#^/embed/([a-zA-Z0-9_-]{11})#', $path, $m)) {
            return $m[1];
        }
        // 3) youtube.com/shorts/VIDEOID
        if (preg_match('#^/shorts/([a-zA-Z0-9_-]{11})#', $path, $m)) {
            return $m[1];
        }
        // 4) youtube.com/v/VIDEOID
        if (preg_match('#^/v/([a-zA-Z0-9_-]{11})#', $path, $m)) {
            return $m[1];
        }
    }

    // 5) youtu.be/VIDEOID
    if (strpos($host, 'youtu.be') !== false) {
        if (preg_match('#^/([a-zA-Z0-9_-]{11})#', $path, $m)) {
            return $m[1];
        }
    }

    return null;
}

$err = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit'])) {
    $link_yt_raw = $_POST['link_yt'] ?? '';
    $videoId = extractYouTubeId($link_yt_raw);

    if (!$videoId) {
        $err = 'Link YouTube tidak valid. Gunakan format seperti https://youtu.be/VID atau https://www.youtube.com/watch?v=VID';
    } else {
        // Simpan hanya videoId
        $stmt = $conn->prepare("INSERT INTO tb_hasil_kerja (link_yt) VALUES (?)");
        if ($stmt) {
            $stmt->bind_param("s", $videoId);
            if ($stmt->execute()) {
                echo "<script>alert('Data Hasil Kerja berhasil ditambahkan!');location.href='?page=hasil_kerja';</script>";
                exit;
            } else {
                $err = "Gagal menyimpan: " . htmlspecialchars($stmt->error);
            }
            $stmt->close();
        } else {
            $err = "Gagal menyiapkan query.";
        }
    }
}
?>

<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2 justify-content-center">
                <div class="col-sm-6 text-center">
                    <h1>Tambah Data Hasil Kerja</h1>
                </div>
            </div>
        </div>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <?php if (!empty($err)): ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <?= $err; ?>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    <?php endif; ?>

                    <div class="card card-primary shadow">
                        <form action="" method="POST" novalidate>
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="link_yt">Link YouTube</label>
                                    <input
                                        type="text"
                                        class="form-control"
                                        id="link_yt"
                                        name="link_yt"
                                        placeholder="Tempel link YouTube (watch, youtu.be, shorts, embed, atau langsung VIDEO_ID)"
                                        value="<?= htmlspecialchars($_POST['link_yt'] ?? '') ?>"
                                        required
                                    >
                                    <small class="form-text text-muted">
                                        Contoh: <code>https://youtu.be/dQw4w9WgXcQ</code> atau <code>https://www.youtube.com/watch?v=dQw4w9WgXcQ</code> atau <code>dQw4w9WgXcQ</code>.
                                    </small>
                                </div>

                                <!-- Preview (otomatis saat user isi link) -->
                                <div id="previewWrap" class="mt-3" style="display:none;">
                                    <label class="mb-2">Preview</label>
                                    <div class="embed-responsive embed-responsive-16by9">
                                        <iframe
                                            id="previewIframe"
                                            class="embed-responsive-item"
                                            src=""
                                            allowfullscreen
                                            referrerpolicy="strict-origin-when-cross-origin">
                                        </iframe>
                                    </div>
                                </div>
                            </div>

                            <div class="card-footer d-flex justify-content-end">
                                <button type="submit" name="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </form>
                    </div>

                    <!-- Optional: daftar format yang didukung -->
                    <!--
                    <div class="card mt-2">
                        <div class="card-body py-2">
                            <small class="text-muted">
                                Mendukung: watch?v=, youtu.be/, embed/, shorts/, v/, atau langsung VIDEO_ID (11 karakter).
                            </small>
                        </div>
                    </div>
                    -->
                </div>
            </div>
        </div>
    </section>
</div>

<script>
// JS kecil untuk membikin preview otomatis
(function(){
    const input = document.getElementById('link_yt');
    const wrap  = document.getElementById('previewWrap');
    const iframe= document.getElementById('previewIframe');

    function extractId(val){
        val = (val || '').trim();

        // Kalau 11 char ID
        if (/^[a-zA-Z0-9_-]{11}$/.test(val)) return val;

        try {
            const u = new URL(val);
            const host = u.hostname.toLowerCase();
            const path = u.pathname;

            // watch?v=
            const v = u.searchParams.get('v');
            if (v && /^[a-zA-Z0-9_-]{11}$/.test(v)) return v;

            // youtu.be/ID
            const mShort = path.match(/^\/([a-zA-Z0-9_-]{11})/);
            if (host.includes('youtu.be') && mShort) return mShort[1];

            // /embed/ID
            const mEmbed = path.match(/^\/embed\/([a-zA-Z0-9_-]{11})/);
            if (mEmbed) return mEmbed[1];

            // /shorts/ID
            const mShorts = path.match(/^\/shorts\/([a-zA-Z0-9_-]{11})/);
            if (mShorts) return mShorts[1];

            // /v/ID
            const mV = path.match(/^\/v\/([a-zA-Z0-9_-]{11})/);
            if (mV) return mV[1];
        } catch(e) {
            // bukan URL valid, biarkan saja (mungkin bukan link)
        }
        return null;
    }

    function updatePreview(){
        const id = extractId(input.value);
        if (id){
            iframe.src = "https://www.youtube.com/embed/" + id;
            wrap.style.display = '';
        } else {
            iframe.src = '';
            wrap.style.display = 'none';
        }
    }

    input.addEventListener('input', updatePreview);
    // load awal jika form gagal validasi
    updatePreview();
})();
</script>
