<?php
// tampil.php - Daftar Pengajuan (lengkap, aman)

// Mulai session jika belum
if (session_status() === PHP_SESSION_NONE) session_start();

// Pastikan user terautentikasi (sesuaikan aturan Anda)
if (!isset($_SESSION['id'])) {
    header('Location: index.php?page=login');
    exit;
}

// Koneksi DB - sesuaikan path
require_once "database/koneksi.php";
if (!isset($conn) || !($conn instanceof mysqli)) {
    die('Koneksi database tidak tersedia.');
}

// Pesan untuk UI
$flash_msg = '';
$flash_err = '';

// ====== HANDLE DELETE (POST) ======
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'hapus' && isset($_POST['id'])) {
    $delId = (int)$_POST['id'];
    if ($delId <= 0) {
        $flash_err = 'ID tidak valid.';
    } else {
        // Ambil info pengajuan untuk cek pemilik
        $stmt = $conn->prepare("SELECT id_klien FROM tb_pengajuan WHERE id = ? LIMIT 1");
        $stmt->bind_param('i', $delId);
        $stmt->execute();
        $res = $stmt->get_result();
        $row = $res ? $res->fetch_assoc() : null;
        $stmt->close();

        if (!$row) {
            $flash_err = 'Data pengajuan tidak ditemukan.';
        } else {
            $id_klien_pengajuan = (int)$row['id_klien'];
            $userLevel = strtoupper((string)($_SESSION['level'] ?? ''));
            $userIdKlien = (int)($_SESSION['id_klien'] ?? 0);

            $canDelete = false;
            if ($userLevel === 'ADMIN') $canDelete = true;
            if ($userLevel === 'KLIEN' && $id_klien_pengajuan === $userIdKlien) $canDelete = true;

            if (!$canDelete) {
                $flash_err = 'Anda tidak memiliki izin untuk menghapus data ini.';
            } else {
                // Lakukan delete (gunakan prepared)
                $dstmt = $conn->prepare("DELETE FROM tb_pengajuan WHERE id = ? LIMIT 1");
                $dstmt->bind_param('i', $delId);
                if ($dstmt->execute()) {
                    $flash_msg = 'Pengajuan berhasil dihapus.';
                } else {
                    $flash_err = 'Gagal menghapus: ' . $conn->error;
                }
                $dstmt->close();
            }
        }
    }
}

// ====== Ambil data pengajuan ======
// Jika KLIEN => filter hanya miliknya; ADMIN => tampil semua (ubah jika mau)
$params = [];
$where = "";
if (strtoupper((string)($_SESSION['level'] ?? '')) === 'KLIEN') {
    $idkl = (int)($_SESSION['id_klien'] ?? 0);
    $where = " WHERE k.id = ?";
    $params[] = $idkl;
}

// Susun query: ambil id_klien juga untuk cek kepemilikan
$sql = "
  SELECT
    p.id,
    p.tanggal_pengajuan,
    p.status,
    p.id_klien,
    k.nik,
    k.nama_lengkap
  FROM tb_pengajuan p
  INNER JOIN tb_klien k ON p.id_klien = k.id
  {$where}
  ORDER BY p.tanggal_pengajuan DESC
";
$stmt = $conn->prepare($sql);
if ($stmt === false) {
    die('Gagal menyiapkan query: ' . $conn->error);
}
if (!empty($params)) {
    // hanya satu param (id klien)
    $stmt->bind_param('i', $params[0]);
}
$stmt->execute();
$result = $stmt->get_result();
$rows = $result ? $result->fetch_all(MYSQLI_ASSOC) : [];
$stmt->close();

// Helper: format tanggal (Anda bisa ganti locale)
function fmt_date($d) {
    if (!$d) return '—';
    $ts = strtotime($d);
    if ($ts === false) return htmlspecialchars($d);
    return date('d M Y H:i', $ts);
}
?>
<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Data Pengajuan</title>

  <!-- CSS: sesuaikan path ke assets proyek Anda -->
  <link rel="stylesheet" href="assets/plugins/fontawesome-free/css/all.min.css">
  <link rel="stylesheet" href="assets/css/adminlte.min.css">
  <link rel="stylesheet" href="assets/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="assets/plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
  <link rel="stylesheet" href="assets/plugins/datatables-buttons/css/buttons.bootstrap4.min.css">
  <style>
    .small-td { width: 1%; white-space: nowrap; }
    .table td, .table th { vertical-align: middle; }
  </style>
</head>
<body class="hold-transition sidebar-mini">
<?php
// Jika proyek Anda punya header/navbar, include di sini, misalnya:
// include_once "partials/header.php";
?>
<div class="wrapper">
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
      <!-- Content Header -->
      <section class="content-header">
          <div class="container-fluid">
              <div class="row mb-2">
                  <div class="col-sm-6"><h1>Data Pengajuan</h1></div>
              </div>
          </div>
      </section>

      <!-- Main content -->
      <section class="content">
          <div class="container-fluid">
              <?php if ($flash_msg): ?>
                <div class="alert alert-success"><?= htmlspecialchars($flash_msg) ?></div>
              <?php endif; ?>
              <?php if ($flash_err): ?>
                <div class="alert alert-danger"><?= htmlspecialchars($flash_err) ?></div>
              <?php endif; ?>

              <div class="row">
                  <div class="col-12">
                      <div class="card mt-3">
                          <div class="card-header d-flex align-items-center">
                              <h4 class="flex-grow-1 m-0 font-weight-bold">Data Pengajuan</h4>
                              <?php if (in_array(strtoupper((string)($_SESSION['level'] ?? '')), ['KLIEN','ADMIN'])) : ?>
                                  <a href="?page=tambah_pengajuan" class="btn btn-primary">Tambah</a>
                              <?php endif; ?>
                          </div>

                          <div class="card-body">
                              <div class="table-responsive">
                                  <table id="example2" class="table table-bordered table-striped">
                                      <thead>
                                          <tr>
                                              <th class="text-center">No</th>
                                              <th class="text-center small-td">Tanggal Pengajuan</th>
                                              <th class="text-center">NIK</th>
                                              <th class="text-center">Nama Lengkap</th>
                                              <th class="text-center">Status Pengajuan</th>
                                              <th class="text-center">Aksi</th>
                                          </tr>
                                      </thead>
                                      <tbody>
                                        <?php $no = 1; foreach ($rows as $row): ?>
                                          <tr>
                                              <td class="text-center"><?= $no++ ?></td>
                                              <td class="text-center"><?= htmlspecialchars(fmt_date($row['tanggal_pengajuan'])) ?></td>
                                              <td class="text-center"><?= htmlspecialchars($row['nik'] ?? '—') ?></td>
                                              <td class="text-center"><?= htmlspecialchars($row['nama_lengkap'] ?? '—') ?></td>
                                              <td class="text-center"><?= htmlspecialchars($row['status'] ?? '—') ?></td>
                                              <td class="text-center small-td">
                                                  <a href="?page=detail_pengajuan&id=<?= (int)$row['id'] ?>" class="btn btn-sm btn-info">Detail</a>

                                                  <?php
                                                    $userLevel = strtoupper((string)($_SESSION['level'] ?? ''));
                                                    $userIdKlien = (int)($_SESSION['id_klien'] ?? 0);
                                                    $rowIdKlien = (int)($row['id_klien'] ?? 0);
                                                    $canEdit = ($userLevel === 'ADMIN') || ($userLevel === 'KLIEN' && $rowIdKlien === $userIdKlien);
                                                  ?>
                                                  <?php if ($canEdit): ?>
                                                    <a href="?page=edit_pengajuan&id=<?= (int)$row['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
                                                  <?php endif; ?>

                                                  <?php if ($canEdit): ?>
                                                    <form action="" method="POST" class="d-inline" onsubmit="return confirm('Yakin ingin menghapus pengajuan ini?');">
                                                      <input type="hidden" name="action" value="hapus">
                                                      <input type="hidden" name="id" value="<?= (int)$row['id'] ?>">
                                                      <button type="submit" class="btn btn-sm btn-danger">Hapus</button>
                                                    </form>
                                                  <?php endif; ?>
                                              </td>
                                          </tr>
                                        <?php endforeach; ?>
                                      </tbody>
                                  </table>
                              </div>
                          </div>
                      </div>
                  </div>
              </div>
          </div>
      </section>
  </div>
</div>

<!-- JS: jQuery, Bootstrap, DataTables (sesuaikan path dengan project Anda) -->
<script src="assets/plugins/jquery/jquery.min.js"></script>
<script src="assets/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>

<script src="assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="assets/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="assets/plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="assets/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>

<script>
  $(function() {
      $('#example2').DataTable({
          "paging": true,
          "lengthChange": true,
          "searching": true,
          "ordering": true,
          "info": true,
          "autoWidth": false,
          "responsive": true,
      });
  });
</script>
</body>
</html>
