<?php
// tambah.php - Tambah Pengajuan
if (session_status() === PHP_SESSION_NONE) session_start();
require_once "database/koneksi.php"; // sesuaikan path

// Pastikan koneksi
if (!isset($conn) || !($conn instanceof mysqli)) {
    die("Koneksi database tidak tersedia.");
}

// Hanya KLIEN atau ADMIN yang boleh akses
$level = strtoupper((string)($_SESSION['level'] ?? ''));
if (!in_array($level, ['KLIEN', 'ADMIN'])) {
    echo "<script>alert('Anda tidak memiliki izin untuk menambah pengajuan.');window.location.href='index.php';</script>";
    exit;
}

// Utility: escape atau NULL literal
function esc($conn, $v) {
    if ($v === null || $v === '') return 'NULL';
    return "'" . $conn->real_escape_string((string)$v) . "'";
}

// untuk menampung pesan
$errors = [];
$success = false;

// Jika ADMIN, ambil list klien
$klienList = [];
if ($level === 'ADMIN') {
    $qr = $conn->query("SELECT id, nik, nama_lengkap FROM tb_klien ORDER BY nama_lengkap ASC");
    if ($qr) $klienList = $qr->fetch_all(MYSQLI_ASSOC);
}

// Ambil opsi dropdown untuk pilihan layanan
$opsi_konsep = $conn->query("SELECT id, nama FROM tb_konsep ORDER BY nama ASC")->fetch_all(MYSQLI_ASSOC);
$opsi_produksi = $conn->query("SELECT id, nama, harga FROM tb_produksi ORDER BY nama ASC")->fetch_all(MYSQLI_ASSOC);

// Handle POST
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit'])) {
    // id_klien dari session jika KLIEN, atau dari form jika ADMIN
    if ($level === 'KLIEN') {
        $id_klien = (int)($_SESSION['id_klien'] ?? 0);
        if ($id_klien <= 0) $errors[] = 'Id klien tidak ditemukan di session.';
    } else {
        $id_klien = isset($_POST['id_klien']) ? (int)$_POST['id_klien'] : 0;
        if ($id_klien <= 0) $errors[] = 'Pilih klien yang valid.';
    }

    // Ambil input
    $nik_l           = isset($_POST['nik_l']) ? trim($_POST['nik_l']) : null;
    $nama_l          = isset($_POST['nama_l']) ? trim($_POST['nama_l']) : null;
    $nomor_telepon_l = isset($_POST['nomor_telepon_l']) ? trim($_POST['nomor_telepon_l']) : null;

    $tempat_wedding  = isset($_POST['tempat_wedding']) ? trim($_POST['tempat_wedding']) : null;
    $tanggal_wedding = isset($_POST['tanggal_wedding']) && $_POST['tanggal_wedding'] !== '' ? trim($_POST['tanggal_wedding']) : null;

    $konsep   = isset($_POST['konsep']) && $_POST['konsep'] !== '' ? (int)$_POST['konsep'] : null;
    $dekorasi = isset($_POST['dekorasi']) && $_POST['dekorasi'] !== '' ? (int)$_POST['dekorasi'] : null;

    // Validasi dasar
    if (!$konsep) $errors[] = 'Pilih konsep / tema.';
    if (!$nik_l) $errors[] = 'NIK wajib diisi.';
    if (!$nama_l) $errors[] = 'Nama lengkap wajib diisi.';

    // ===== Upload foto (opsional) =====
    $foto_l = null;
    $target_dir = __DIR__ . '/uploads/';
    if (!is_dir($target_dir)) {
        @mkdir($target_dir, 0775, true);
    }

    if (!empty($_FILES['foto_l']['name']) && is_uploaded_file($_FILES['foto_l']['tmp_name'])) {
        $file = $_FILES['foto_l'];
        $maxBytes = 3 * 1024 * 1024; // 3MB
        if ($file['size'] > $maxBytes) {
            $errors[] = 'Foto terlalu besar. Maks 3MB.';
        } else {
            $allowed = ['jpg','jpeg','png','webp'];
            $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
            if (!in_array($ext, $allowed)) {
                $errors[] = 'Format foto tidak diperbolehkan (jpg/jpeg/png/webp).';
            } else {
                $base = pathinfo($file['name'], PATHINFO_FILENAME);
                $safeBase = preg_replace('/[^a-zA-Z0-9_\-]/', '_', $base);
                $new = $safeBase . '_' . date('Ymd_His') . '_' . bin2hex(random_bytes(4)) . '.' . $ext;
                $dest = $target_dir . $new;
                if (move_uploaded_file($file['tmp_name'], $dest)) {
                    // simpan path relatif ke project
                    $foto_l = 'uploads/' . $new;
                } else {
                    $errors[] = 'Gagal menyimpan file foto.';
                }
            }
        }
    }

    // Jika tidak ada error, lakukan insert
    if (empty($errors)) {
        // Kolom yang diisi eksplisit (sesuaikan dengan struktur DB Anda)
        $query = "
            INSERT INTO tb_pengajuan
            (id_klien, konsep, dekorasi, dokumentasi, lighting, sound, band, mc, mua,
             nik_l, nama_l, nama_ayah_l, nama_ibu_l, tempat_lahir_l, tanggal_lahir_l, nomor_telepon_l, foto_l,
             nik_p, nama_p, nama_ayah_p, nama_ibu_p, tempat_lahir_p, tanggal_lahir_p, nomor_telepon_p, foto_p,
             tempat_wedding, tanggal_wedding, tanggal_pengajuan, tanggal_disetujui, status, keterangan)
            VALUES (
                " . esc($conn, $id_klien) . ",
                " . esc($conn, $konsep) . ",
                " . esc($conn, $dekorasi) . ",
                NULL, NULL, NULL, NULL, NULL, NULL,
                " . esc($conn, $nik_l) . ",
                " . esc($conn, $nama_l) . ",
                NULL, NULL, NULL, NULL,
                " . esc($conn, $nomor_telepon_l) . ",
                " . esc($conn, $foto_l) . ",
                NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
                " . esc($conn, $tempat_wedding) . ",
                " . esc($conn, $tanggal_wedding) . ",
                NOW(), NULL, 'Pending', NULL
            )
        ";

        if ($conn->query($query)) {
            $success = true;
            // redirect ke daftar
            echo "<script>alert('Pengajuan berhasil dilakukan!');window.location.href='?page=pengajuan';</script>";
            exit;
        } else {
            $errors[] = 'Gagal menyimpan: ' . $conn->error;
            // jika ada file yang sudah diupload, bisa dihapus untuk kebersihan (opsional)
            if ($foto_l && is_file(__DIR__ . '/' . $foto_l)) {
                @unlink(__DIR__ . '/' . $foto_l);
            }
        }
    }
}

?>
<!-- HTML FORM -->
<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Tambah Pengajuan</title>
    <link rel="stylesheet" href="assets/plugins/fontawesome-free/css/all.min.css">
    <link rel="stylesheet" href="assets/css/adminlte.min.css">
    <link rel="stylesheet" href="assets/plugins/select2/css/select2.min.css">
    <link rel="stylesheet" href="assets/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css">
</head>
<body class="hold-transition sidebar-mini">
<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid"><div class="row mb-2"><div class="col-sm-6"><h1>Tambah Pengajuan</h1></div></div></div>
    </section>

    <section class="content">
        <div class="container-fluid">
            <?php if (!empty($errors)): ?>
                <div class="alert alert-danger">
                    <?php foreach ($errors as $e) echo '<div>' . htmlspecialchars($e) . '</div>'; ?>
                </div>
            <?php endif; ?>

            <form action="" method="POST" enctype="multipart/form-data" novalidate>
                <div class="row">
                    <!-- STEP A -->
                    <div id="a" class="col-md-12">
                        <div class="card card-primary">
                            <div class="card-header"><h3 class="card-title">Identitas Calon Client</h3></div>
                            <div class="card-body">
                                <?php if ($level === 'ADMIN'): ?>
                                    <div class="form-group">
                                        <label for="id_klien">Pilih Klien</label>
                                        <select name="id_klien" id="id_klien" class="form-control select2">
                                            <option value="">-- Pilih Klien --</option>
                                            <?php foreach ($klienList as $k): ?>
                                                <option value="<?= (int)$k['id'] ?>" <?= (isset($_POST['id_klien']) && (int)$_POST['id_klien'] === (int)$k['id']) ? 'selected' : '' ?>>
                                                    <?= htmlspecialchars($k['nik'] . ' — ' . $k['nama_lengkap']) ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                <?php else: ?>
                                    <div class="form-group">
                                        <label>Klien</label>
                                        <div class="form-control-plaintext"><?= htmlspecialchars($_SESSION['nama'] ?? '-') ?></div>
                                    </div>
                                <?php endif; ?>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="nik_l">NIK</label>
                                            <input type="text" name="nik_l" id="nik_l" class="form-control" value="<?= isset($_POST['nik_l']) ? htmlspecialchars($_POST['nik_l']) : '' ?>" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="nama_l">Nama Lengkap</label>
                                            <input type="text" name="nama_l" id="nama_l" class="form-control" value="<?= isset($_POST['nama_l']) ? htmlspecialchars($_POST['nama_l']) : '' ?>" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="nomor_telepon_l">Nomor Telepon</label>
                                            <input type="text" name="nomor_telepon_l" id="nomor_telepon_l" class="form-control" value="<?= isset($_POST['nomor_telepon_l']) ? htmlspecialchars($_POST['nomor_telepon_l']) : '' ?>">
                                        </div>

                                        <div class="form-group">
                                            <label for="foto_l">Foto KTP (opsional)</label>
                                            <div class="custom-file">
                                                <input type="file" class="custom-file-input" id="foto_l" name="foto_l" accept="image/*">
                                                <label class="custom-file-label" id="label_gambar_l" for="foto_l">Pilih gambar</label>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label for="tempat_wedding">Area Pengurusan</label>
                                            <input type="text" name="tempat_wedding" id="tempat_wedding" class="form-control" value="<?= isset($_POST['tempat_wedding']) ? htmlspecialchars($_POST['tempat_wedding']) : '' ?>">
                                        </div>
                                        <div class="form-group">
                                            <label for="tanggal_wedding">Tanggal Pengurusan</label>
                                            <input type="date" name="tanggal_wedding" id="tanggal_wedding" class="form-control" value="<?= isset($_POST['tanggal_wedding']) ? htmlspecialchars($_POST['tanggal_wedding']) : '' ?>">
                                        </div>
                                    </div>

                                    <div class="col-md-6 text-center">
                                        <label class="h5">Preview Gambar</label>
                                        <div class="mt-4">
                                            <img id="preview-foto-l" src="assets/img/pp.png" class="img-thumbnail" style="width:300px;height:400px;object-fit:cover;">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="card-footer d-flex justify-content-end">
                                <button type="reset" class="btn btn-secondary mr-2">Reset</button>
                                <button id="next-btn" type="button" class="btn btn-primary">Next</button>
                            </div>
                        </div>
                    </div>

                    <!-- STEP B -->
                    <div id="b" class="col-md-12 d-none">
                        <div class="card card-primary">
                            <div class="card-header"><h3 class="card-title">Pilih Jasa</h3></div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="konsep">Konsep / Tema</label>
                                            <select name="konsep" id="konsep" class="form-control select2" onchange="berubah(this,'konsep',false)">
                                                <option value="">-- Pilih Tema --</option>
                                                <?php foreach ($opsi_konsep as $o): ?>
                                                    <option value="<?= (int)$o['id'] ?>" data-id="<?= (int)$o['id'] ?>" data-nama="<?= htmlspecialchars($o['nama']) ?>"><?= htmlspecialchars($o['nama']) ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>

                                        <div class="form-group">
                                            <label for="dekorasi">Dekorasi</label>
                                            <select name="dekorasi" id="dekorasi" class="form-control select2" onchange="berubah(this,'produksi','dekorasi')">
                                                <option value="">-- Pilih Dekorasi --</option>
                                                <?php foreach ($opsi_produksi as $p): ?>
                                                    <option value="<?= (int)$p['id'] ?>" data-id="<?= (int)$p['id'] ?>" data-nama="<?= htmlspecialchars($p['nama']) ?>" data-harga="<?= (int)$p['harga'] ?>"><?= htmlspecialchars($p['nama']) ?> | Rp <?= number_format($p['harga'],0,',','.') ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-8">
                                        <div class="card mb-3" style="height: 420px;">
                                            <div class="card-body d-flex">
                                                <div id="carouselExampleControls" class="carousel slide" data-ride="carousel">
                                                    <div class="carousel-inner" style="width:400px;height:350px;"></div>
                                                    <a class="carousel-control-prev" href="#carouselExampleControls" role="button" data-slide="prev">
                                                        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                                    </a>
                                                    <a class="carousel-control-next" href="#carouselExampleControls" role="button" data-slide="next">
                                                        <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                                    </a>
                                                </div>
                                                <div class="pl-3">
                                                    <h3 id="nama_master"></h3>
                                                    <p id="detail_master"></p>
                                                </div>
                                            </div>
                                        </div>
                                        <h4 id="total_biaya">Total Biaya: Rp. 0</h4>
                                    </div>
                                </div>
                            </div>

                            <div class="card-footer d-flex justify-content-end">
                                <button id="back" type="button" class="btn btn-secondary mr-2">Back</button>
                                <button type="submit" name="submit" class="btn btn-success">Submit</button>
                            </div>
                        </div>
                    </div>

                </div>
            </form>
        </div>
    </section>
</div>

<!-- JS assets (pastikan file ada di project) -->
<script src="assets/plugins/jquery/jquery.min.js"></script>
<script src="assets/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="assets/plugins/select2/js/select2.full.min.js"></script>
<script>
    // Init select2
    if (typeof $.fn.select2 !== 'undefined') {
        $('.select2').select2({ theme: 'bootstrap4' });
    }

    // Step navigation
    document.querySelector('#next-btn').addEventListener('click', function() {
        document.querySelector('#a').classList.toggle('d-none');
        document.querySelector('#b').classList.toggle('d-none');
    });
    document.querySelector('#back').addEventListener('click', function() {
        document.querySelector('#b').classList.toggle('d-none');
        document.querySelector('#a').classList.toggle('d-none');
    });

    // Preview foto
    $("#foto_l").on('change', function() {
        const file = this.files && this.files[0];
        if (!file) return;
        const reader = new FileReader();
        reader.onload = function(e) {
            $("#preview-foto-l").attr('src', e.target.result);
            $("#label_gambar_l").text(file.name);
        }
        reader.readAsDataURL(file);
    });

    // Placeholder gambar data (server side) - jika Anda punya $gambar array, Anda dapat inisialisasi JS di sini
    let gambar = {}; // optional
    let total_biaya = {};

    function berubah(element, jenis, hargaKey) {
        const opt = element.options[element.selectedIndex];
        const id = opt.getAttribute('data-id');
        const nama = opt.getAttribute('data-nama') || '';
        const detail = opt.getAttribute('data-detail') || '';
        const harga = parseInt((opt.getAttribute('data-harga') || '0').replace(/[^0-9]/g,'')) || 0;

        document.querySelector("#nama_master").textContent = nama;
        document.querySelector("#detail_master").textContent = detail;

        const container = document.querySelector(".carousel-inner");
        container.innerHTML = "";
        // jika Anda punya gambar[jenis][id] di-echo dari PHP, gunakan untuk mengisi carousel
        if (gambar[jenis] && gambar[jenis][id] && gambar[jenis][id].length) {
            container.insertAdjacentHTML('beforeend', `
                <div class="carousel-item active">
                    <img src="${gambar[jenis][id][0]['gambar']}" width="400" height="350" style="object-fit:cover">
                </div>
            `);
            for (let i = 1; i < gambar[jenis][id].length; i++) {
                container.insertAdjacentHTML('beforeend', `
                    <div class="carousel-item">
                        <img src="${gambar[jenis][id][i]['gambar']}" width="400" height="350" style="object-fit:cover">
                    </div>
                `);
            }
        }

        if (hargaKey) total_biaya[hargaKey] = harga;
        let total = 0;
        for (const k in total_biaya) total += (total_biaya[k] || 0);
        document.querySelector("#total_biaya").textContent = formatRupiah(total.toString(), "Rp. ");
    }

    function formatRupiah(angka, prefix) {
        var number_string = (angka || '').replace(/[^,\d]/g, '').toString(),
            split = number_string.split(','),
            sisa = split[0].length % 3,
            rupiah = split[0].substr(0, sisa),
            ribuan = split[0].substr(sisa).match(/\d{3}/gi);

        if (ribuan) {
            var separator = sisa ? '.' : '';
            rupiah += separator + ribuan.join('.');
        }

        rupiah = split[1] != undefined ? rupiah + ',' + split[1] : rupiah;
        return prefix == undefined ? rupiah : (rupiah ? prefix + ' ' + rupiah : '');
    }
</script>
</body>
</html>
