<?php
// hapus.php - Hapus data pengajuan dengan izin yang aman

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Pastikan koneksi ada
require_once "database/koneksi.php";
if (!isset($conn) || !($conn instanceof mysqli)) {
    die("Koneksi database tidak tersedia.");
}

// Cek login
if (!isset($_SESSION['id']) || empty($_SESSION['level'])) {
    echo "<script>alert('Silakan login terlebih dahulu!');window.location.href='index.php?page=login';</script>";
    exit;
}

// Pastikan ada parameter id
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    echo "<script>alert('Parameter ID tidak valid!');window.location.href='?page=pengajuan';</script>";
    exit;
}

$id = (int)$_GET['id'];

// Ambil data pengajuan untuk cek siapa pemiliknya
$stmt = $conn->prepare("SELECT id_klien FROM tb_pengajuan WHERE id = ? LIMIT 1");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$data = $result->fetch_assoc();
$stmt->close();

if (!$data) {
    echo "<script>alert('Data pengajuan tidak ditemukan!');window.location.href='?page=pengajuan';</script>";
    exit;
}

// Cek hak akses
$userLevel = strtoupper((string)$_SESSION['level']);
$userIdKlien = (int)($_SESSION['id_klien'] ?? 0);
$canDelete = false;

if ($userLevel === "ADMIN") {
    $canDelete = true;
} elseif ($userLevel === "KLIEN" && $data['id_klien'] == $userIdKlien) {
    $canDelete = true;
}

if (!$canDelete) {
    echo "<script>alert('Anda tidak memiliki izin untuk menghapus pengajuan ini!');window.location.href='?page=pengajuan';</script>";
    exit;
}

// Eksekusi penghapusan
$deleteStmt = $conn->prepare("DELETE FROM tb_pengajuan WHERE id = ? LIMIT 1");
$deleteStmt->bind_param("i", $id);

if ($deleteStmt->execute()) {
    echo "<script>alert('Pengajuan berhasil dihapus!');window.location.href='?page=pengajuan';</script>";
} else {
    echo "<script>alert('Gagal menghapus pengajuan: " . addslashes($conn->error) . "');window.location.href='?page=pengajuan';</script>";
}
$deleteStmt->close();
?>
