<?php
if (!isset($conn)) { die('Koneksi belum tersedia'); }

if (isset($_GET['id'])) {
    $id = (int)$_GET['id'];
    $query = "
        SELECT 
            p.*,
            k.nik,
            k.nama_lengkap,
            k.email,
            (SELECT nama  FROM tb_konsep   WHERE id = p.konsep)   AS nama_konsep,
            (SELECT nama  FROM tb_produksi WHERE id = p.dekorasi) AS nama_dekorasi,
            (SELECT harga FROM tb_produksi WHERE id = p.dekorasi) AS harga_dekorasi
        FROM tb_pengajuan p
        INNER JOIN tb_klien k ON p.id_klien = k.id
        WHERE p.id = {$id}
    ";
    $result = $conn->query($query);
    $data   = $result ? $result->fetch_assoc() : null;
    if (!$data) {
        echo "<script>alert('Data tidak ditemukan');window.location.href='?page=pengajuan';</script>";
        exit;
    }
} else {
    echo "<script>window.location.href='?page=pengajuan';</script>";
    exit;
}

if (isset($_POST['disetujui']) && !empty($data['id'])) {
    $conn->query("UPDATE tb_pengajuan SET status='Disetujui' WHERE id=" . (int)$data['id']);
    if (!empty($data['email'])) {
        new MailSender($data['email'], "PENGAJUAN", "DISETUJUI");
    }
    echo "<script>window.location.href='?page=pengajuan';</script>";
    exit;
}

function tgl_indo_safe($ymd, $bulanArr) {
    if (empty($ymd) || $ymd === '0000-00-00') return '-';
    $part = explode(' ', $ymd)[0];
    $seg  = explode('-', $part);
    if (count($seg) !== 3) return htmlspecialchars($part);
    $tahun = (int)$seg[0]; $bulan = (int)$seg[1]; $tanggal = (int)$seg[2];
    if (isset($bulanArr[$bulan-1])) {
        return $tanggal . " " . $bulanArr[$bulan-1] . " " . $tahun;
    }
    return htmlspecialchars($part);
}

function build_asset_url($relPath) {
    if (!$relPath) return '';
    $p = str_replace('\\', '/', trim($relPath));
    if (strpos($p, './') === 0) $p = substr($p, 2);
    if (preg_match('~^https?://~i', $p)) return $p;
    $docRoot = rtrim(str_replace('\\','/', $_SERVER['DOCUMENT_ROOT']), '/');
    if (strpos($p, $docRoot) === 0) {
        $p = ltrim(substr($p, strlen($docRoot)), '/');
    }
    $base = rtrim(str_replace('\\','/', dirname($_SERVER['PHP_SELF'])), '/');
    if ($base === '/') $base = '';
    return $base . '/' . ltrim($p, '/');
}
?>
<style>
    .kv-table { width:100%; border-collapse:separate; border-spacing:0; }
    .kv-table th, .kv-table td { padding:.6rem .8rem; vertical-align:top; border-bottom:1px solid #eee; }
    .kv-table th { width:38%; color:#555; font-weight:600; white-space:nowrap; }
    .kv-table td { color:#111; }

    .price-table { width:100%; border-collapse:separate; border-spacing:0; }
    .price-table th, .price-table td { padding:.55rem .8rem; border-bottom:1px dashed #e7e7e7; }
    .price-table th { color:#666; font-weight:600; }
    .price-table td.text-right { text-align:right; font-variant-numeric:tabular-nums; }

    .section-title { font-weight:700; margin-bottom:.75rem; border-left:4px solid #3c8dbc; padding-left:.5rem; }
    .soft-card { border:1px solid #eee; border-radius:.5rem; padding:1rem; background:#fff; box-shadow:0 1px 2px rgba(0,0,0,.03); }

    /* === Perbaikan tampilan foto: full tanpa crop === */
    .photo-wrap {
        max-width: 420px;      /* atur batas maksimum lebar tampilan foto di halaman */
        width: 100%;
        border:1px solid #eee;
        border-radius:.35rem;
        padding:.5rem;
        background:#fafafa;
    }
    .photo {
        display:block;
        width:100%;            /* isi seluruh lebar container */
        height:auto;           /* tinggi menyesuaikan rasio asli */
        object-fit:contain;    /* TIDAK memotong gambar (no crop) */
        border-radius:.2rem;
    }

    .badge { padding:.35rem .55rem; font-weight:600; border-radius:.35rem; }
    .badge-warning { background:#ffc107; color:#111; }
    .badge-success { background:#28a745; color:#fff; }
    .badge-secondary { background:#6c757d; color:#fff; }

    @media print {
        body * { visibility:hidden; }
        #section-to-print, #section-to-print * { visibility:visible; }
        #section-to-print { position:absolute; left:0; top:0; width:100%; }
        .card, .soft-card, .photo-wrap { border:none !important; box-shadow:none !important; background:#fff !important; }
        .kv-table th, .kv-table td, .price-table th, .price-table td { border-bottom:1px solid #ddd !important; }
        @page { size: landscape; margin: 10mm; }
    }
</style>

<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6"><h1 class="m-0">Detail Pengajuan</h1></div>
            </div>
        </div>
    </section>

    <section class="content">
        <div class="container-fluid" id="section-to-print">
            <div class="row">
                <div class="col-12">
                    <div class="card card-primary">
                        <div class="card-header"><h3 class="card-title m-0">Data Pengajuan</h3></div>

                        <div class="card-body">
                            <div class="row">
                                <!-- Kiri -->
                                <div class="col-lg-6 mb-3">
                                    <div class="soft-card mb-3">
                                        <div class="section-title m-0">Data Pemohon</div>
                                        <table class="kv-table">
                                            <tr>
                                                <th>NIK</th>
                                                <td><?= htmlspecialchars($data['nik_l'] ?? '-') ?></td>
                                            </tr>
                                            <tr>
                                                <th>Nama Lengkap</th>
                                                <td><?= htmlspecialchars($data['nama_l'] ?? '-') ?></td>
                                            </tr>
                                            <tr>
                                                <th>Nomor Telepon</th>
                                                <td><?= htmlspecialchars($data['nomor_telepon_l'] ?? '-') ?></td>
                                            </tr>
                                            <tr>
                                                <th>Foto KTP</th>
                                                <td>
                                                    <?php if (!empty($data['foto_l'])): ?>
                                                        <?php $imgUrl = build_asset_url($data['foto_l']); ?>
                                                        <div class="photo-wrap">
                                                            <img src="<?= htmlspecialchars($imgUrl) ?>" alt="Foto KTP" class="photo"
                                                                 onerror="this.closest('.photo-wrap').outerHTML='<span class=&quot;text-muted&quot;>Gagal memuat foto: <?= htmlspecialchars($imgUrl) ?></span>';">
                                                        </div>
                                                    <?php else: ?>
                                                        <span class="text-muted">Belum mengunggah foto</span>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>

                                    <div class="soft-card">
                                        <div class="section-title m-0">Detail Pengurusan</div>
                                        <table class="kv-table">
                                            <tr>
                                                <th>Area Pengurusan</th>
                                                <td><?= htmlspecialchars($data['tempat_wedding'] ?? '-') ?></td>
                                            </tr>
                                            <tr>
                                                <th>Tanggal Pengurusan</th>
                                                <td><?= tgl_indo_safe($data['tanggal_wedding'] ?? '', $BULAN_DALAM_INDONESIA) ?></td>
                                            </tr>
                                            <tr>
                                                <th>Status</th>
                                                <td>
                                                    <?php
                                                    $status = $data['status'] ?? '-';
                                                    $badge  = $status==='Pending' ? 'badge-warning' : ($status==='Disetujui' ? 'badge-success' : 'badge-secondary');
                                                    ?>
                                                    <span class="badge <?= $badge ?>"><?= htmlspecialchars($status) ?></span>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>

                                <!-- Kanan -->
                                <div class="col-lg-6 mb-3">
                                    <div class="soft-card mb-3">
                                        <div class="section-title m-0">Rincian Jasa</div>
                                        <table class="kv-table">
                                            <tr>
                                                <th>Jenis Layanan</th>
                                                <td><?= htmlspecialchars($data['nama_konsep'] ?? '-') ?></td>
                                            </tr>
                                            <tr>
                                                <th>Jasa</th>
                                                <td><?= htmlspecialchars($data['nama_dekorasi'] ?? '-') ?></td>
                                            </tr>
                                        </table>
                                    </div>

                                    <div class="soft-card">
                                        <div class="section-title m-0">Ringkasan Biaya</div>
                                        <?php $harga_dekorasi = (int)($data['harga_dekorasi'] ?? 0); ?>
                                        <table class="price-table">
                                            <tr>
                                                <th>Jenis Perizinan</th>
                                                <td class="text-right">Rp&nbsp;0</td>
                                            </tr>
                                            <tr>
                                                <th>Jasa</th>
                                                <td class="text-right">Rp&nbsp;<?= number_format($harga_dekorasi, 0, ",", "."); ?></td>
                                            </tr>
                                            <tr>
                                                <th style="border-bottom:0; padding-top:.9rem;">Total</th>
                                                <td class="text-right" style="border-bottom:0; font-weight:700; padding-top:.9rem;">
                                                    Rp&nbsp;<?= number_format($harga_dekorasi, 0, ",", "."); ?>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div><!-- /row -->
                        </div>

                        <div class="card-footer d-flex justify-content-end">
                            <a href="?page=pengajuan" class="btn btn-secondary mr-3">Kembali</a>
                            <button id="cetak" class="btn btn-info mr-3" type="button">Cetak</button>

                            <?php if (!empty($data['status']) && $data['status'] == 'Pending' && isset($_SESSION['level']) && $_SESSION['level'] == 'ADMIN') : ?>
                                <a href="?page=tolak_pengajuan&email=<?= urlencode($data['email']) ?>&id=<?= (int)$data['id'] ?>" class="btn btn-danger mr-3">Tolak</a>
                                <a href="?page=setujui_pengajuan&email=<?= urlencode($data['email']) ?>&id=<?= (int)$data['id'] ?>" class="btn btn-success">Setujui</a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

            </div><!-- /row -->
        </div><!-- /container-fluid -->
    </section>

    <script>
      document.querySelector("#cetak").addEventListener('click', function() {
        window.print();
      });
    </script>
</div>
