<?php
if (!isset($conn)) { die('Koneksi belum tersedia'); }

if (!isset($_GET['id'])) {
    echo "<script>window.location.href='?page=pembayaran';</script>";
    exit;
}
$id = (int)$_GET['id'];

$sql = "
    SELECT
        p.*,                               -- tb_pengajuan
        k.nik,
        k.nama_lengkap,
        k.email,                           -- tb_klien
        a.id AS id_anggaran,
        a.anggaran_tambahan,
        a.detail_anggaran,                 -- tb_anggaran
        pay.status  AS status_pembayaran,
        pay.id      AS id_pembayaran,
        pay.file_bukti_pembayaran,         -- tb_pembayaran
        b.nama      AS nama_bank,
        b.atas_nama,
        b.no_rek,                          -- tb_bank
        (SELECT nama  FROM tb_konsep   WHERE id = p.konsep)   AS nama_konsep,
        (SELECT nama  FROM tb_produksi WHERE id = p.dekorasi) AS nama_dekorasi,
        (SELECT harga FROM tb_produksi WHERE id = p.dekorasi) AS harga_dekorasi
    FROM tb_pengajuan p
    INNER JOIN tb_klien k     ON p.id_klien = k.id
    INNER JOIN tb_anggaran a  ON p.id       = a.id_pengajuan
    LEFT  JOIN tb_pembayaran pay ON a.id    = pay.id_anggaran
    LEFT  JOIN tb_bank b         ON b.id    = pay.id_bank
    WHERE p.id = {$id}
";
$res  = $conn->query($sql);
$data = $res ? $res->fetch_assoc() : null;

if (!$data) {
    echo "<script>alert('Data tidak ditemukan');window.location.href='?page=pembayaran';</script>";
    exit;
}

$harga_dekorasi    = (int)($data['harga_dekorasi'] ?? 0);
$anggaran_tambahan = (int)($data['anggaran_tambahan'] ?? 0);
$total_bayar       = $harga_dekorasi + $anggaran_tambahan;

function rupiah($n){ return number_format((int)$n, 0, ",", "."); }

/* Aksi verifikasi (ADMIN) */
if (isset($_POST['verifikasi']) && isset($_SESSION['level']) && $_SESSION['level'] === 'ADMIN') {
    $keterangan = $conn->real_escape_string($_POST['keterangan'] ?? '');
    if ($_POST['verifikasi'] === 'tolak') {
        $conn->query("UPDATE tb_pembayaran SET keterangan='{$keterangan}', status='Ditolak', tanggal_verifikasi='".date('Y-m-d H:i:s')."' WHERE id=".(int)$data['id_pembayaran']);
        echo "<script>alert('Berhasil verifikasi: Ditolak');window.location.href='?page=pembayaran';</script>";
        exit;
    } elseif ($_POST['verifikasi'] === 'verifikasi') {
        $conn->query("UPDATE tb_pembayaran SET keterangan='{$keterangan}', status='Terverifikasi', tanggal_verifikasi='".date('Y-m-d H:i:s')."' WHERE id=".(int)$data['id_pembayaran']);
        echo "<script>alert('Berhasil verifikasi: Terverifikasi');window.location.href='?page=pembayaran';</script>";
        exit;
    }
}
?>
<style>
    /* Gaya bersih & responsif */
    .section-title{font-weight:700;margin:0 0 .75rem;border-left:4px solid #3c8dbc;padding-left:.5rem}
    .soft-card{border:1px solid #e9eef3;border-radius:.75rem;padding:1rem;background:#fff;box-shadow:0 6px 12px rgba(17,24,39,.06)}
    .kv-table{width:100%;border-collapse:separate;border-spacing:0}
    .kv-table th,.kv-table td{padding:.6rem .8rem;vertical-align:top;border-bottom:1px solid #eef0f2}
    .kv-table th{width:38%;color:#586170;font-weight:600;white-space:nowrap}
    .kv-table td{color:#1f2937}
    .price-table{width:100%;border-collapse:separate;border-spacing:0}
    .price-table th,.price-table td{padding:.55rem .8rem;border-bottom:1px dashed #e6e8eb}
    .price-table th{color:#6b7280;font-weight:600}
    .price-table td.text-right{text-align:right;font-variant-numeric:tabular-nums}
    .badge{padding:.35rem .55rem;font-weight:600;border-radius:.35rem}
    .badge-warning{background:#ffc107;color:#111}
    .badge-success{background:#28a745;color:#fff}
    .badge-secondary{background:#6c757d;color:#fff}
    .sticky-summary{position:sticky;top:1rem}
    .thumb{max-width:220px;border:1px solid #e6e6e6;border-radius:.5rem;object-fit:cover;cursor:pointer;box-shadow:0 4px 10px rgba(0,0,0,.05)}
    .btn-soft{background:#f7f9fc;border:1px solid #e6ecf2}
    .btn-soft:hover{background:#eef3f8}

    @media print{
        body *{visibility:hidden}
        #section-to-print,#section-to-print *{visibility:visible}
        #section-to-print{position:absolute;left:0;top:0;width:100%}
        .soft-card,.card{box-shadow:none !important;border:1px solid #ddd !important}
        .no-print{display:none !important}
        @page{size:portrait;margin:12mm}
    }
</style>

<div class="content-wrapper">
    <!-- Header -->
    <section class="content-header no-print">
        <div class="container-fluid">
            <div class="d-flex align-items-center justify-content-between flex-wrap">
                <h1 class="m-0">Detail Pembayaran</h1>
                <div class="d-flex" style="gap:.5rem">
                    <a href="?page=pembayaran" class="btn btn-outline-secondary">
                        <i class="fas fa-arrow-left mr-1"></i> Kembali
                    </a>
                    <?php if (!empty($data['detail_anggaran'])): ?>
                        <a href="<?= htmlspecialchars($data['detail_anggaran']) ?>" target="_blank" rel="noopener" class="btn btn-soft">
                            <i class="fas fa-file-download mr-1"></i> Download R.A.B
                        </a>
                    <?php endif; ?>
                    <button type="button" id="btn-print" class="btn btn-primary">
                        <i class="fas fa-print mr-1"></i> Cetak
                    </button>
                </div>
            </div>
        </div>
    </section>

    <!-- Main -->
    <section class="content">
        <div class="container-fluid" id="section-to-print">
            <div class="row">
                <!-- Kolom kiri: Rincian Jasa -->
                <div class="col-lg-7 mb-3">
                    <div class="soft-card mb-3">
                        <div class="section-title">Rincian Jasa</div>
                        <table class="kv-table">
                            <tr>
                                <th>Nama Klien</th>
                                <td><b><?= htmlspecialchars($data['nama_lengkap'] ?? '-') ?></b></td>
                            </tr>
                            <tr>
                                <th>Layanan</th>
                                <td><?= htmlspecialchars($data['nama_konsep'] ?? '-') ?></td>
                            </tr>
                            <tr>
                                <th>Jasa</th>
                                <td><?= htmlspecialchars($data['nama_dekorasi'] ?? '-') ?></td>
                            </tr>
                            <tr>
                                <th>Anggaran Tambahan</th>
                                <td>
                                    Rp&nbsp;<?= rupiah($anggaran_tambahan) ?>
                                    <?php if (!empty($data['detail_anggaran'])): ?>
                                        <a class="btn btn-xs btn-outline-info ml-2 no-print" href="<?= htmlspecialchars($data['detail_anggaran']) ?>" target="_blank" rel="noopener">
                                            <i class="fas fa-file-alt mr-1"></i> Rincian
                                        </a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <th>Status Pengajuan</th>
                                <td>
                                    <?php
                                    $status = $data['status'] ?? '-';
                                    $badge  = $status==='Pending' ? 'badge-warning' : ($status==='Disetujui' ? 'badge-success' : 'badge-secondary');
                                    ?>
                                    <span class="badge <?= $badge ?>"><?= htmlspecialchars($status) ?></span>
                                </td>
                            </tr>
                            <tr>
                                <th>Status Pembayaran</th>
                                <td>
                                    <?php
                                    $sp = $data['status_pembayaran'] ?? '-';
                                    $b2 = $sp==='Terverifikasi' ? 'badge-success' : ($sp==='Ditolak' ? 'badge-warning' : 'badge-secondary');
                                    ?>
                                    <span class="badge <?= $b2 ?>"><?= htmlspecialchars($sp) ?></span>
                                </td>
                            </tr>
                        </table>
                    </div>

                    <?php if (isset($_SESSION['level']) && $_SESSION['level'] === "KLIEN"): ?>
                        <div class="soft-card no-print">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <div class="section-title m-0">Aksi Pembayaran</div>
                                    <small class="text-muted">Total tagihan sesuai ringkasan di samping.</small>
                                </div>
                                <div>
                                <?php if (($data['status_pembayaran'] ?? '') === "Terverifikasi"): ?>
                                    <button class="btn btn-success" disabled>Berhasil Melakukan Pembayaran</button>
                                <?php else: ?>
                                    <a href="?page=tambah_pembayaran&id=<?= (int)$data['id_anggaran'] ?>&total=<?= $total_bayar ?>" class="btn btn-primary">
                                        Lakukan Pembayaran
                                    </a>
                                <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Kolom kanan: Ringkasan Biaya (sticky) -->
                <div class="col-lg-5 mb-3">
                    <div class="soft-card sticky-summary">
                        <div class="d-flex align-items-center justify-content-between mb-2">
                            <div class="section-title m-0">Ringkasan Biaya</div>
                            <span class="badge badge-secondary">ID #<?= (int)$data['id'] ?></span>
                        </div>
                        <table class="price-table mb-3">
                            <tr>
                                <th>Layanan</th>
                                <td class="text-right">Rp&nbsp;0</td>
                            </tr>
                            <tr>
                                <th>Jasa</th>
                                <td class="text-right">Rp&nbsp;<?= rupiah($harga_dekorasi) ?></td>
                            </tr>
                            <tr>
                                <th>Anggaran Tambahan</th>
                                <td class="text-right">Rp&nbsp;<?= rupiah($anggaran_tambahan) ?></td>
                            </tr>
                            <tr>
                                <th style="border-bottom:0;padding-top:.9rem;">Total</th>
                                <td class="text-right" style="border-bottom:0;font-weight:700;padding-top:.9rem;">
                                    Rp&nbsp;<?= rupiah($total_bayar) ?>
                                </td>
                            </tr>
                        </table>

                        <!-- Bukti pembayaran (preview) -->
                        <?php if (!empty($data['file_bukti_pembayaran'])): ?>
                        <div class="mt-3">
                            <div class="section-title m-0">Bukti Pembayaran</div>
                            <a href="<?= htmlspecialchars($data['file_bukti_pembayaran']) ?>" target="_blank" class="d-inline-block mt-2">
                                <img src="<?= htmlspecialchars($data['file_bukti_pembayaran']) ?>" alt="Bukti Pembayaran" class="thumb" />
                            </a>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Panel verifikasi (ADMIN) -->
                <?php if (isset($_SESSION['level']) && $_SESSION['level'] === "ADMIN"): ?>
                    <div class="col-lg-12">
                        <div class="soft-card">
                            <div class="section-title">Verifikasi Pembayaran</div>
                            <div class="row">
                                <div class="col-md-6">
                                    <table class="kv-table">
                                        <tr>
                                            <th>Nama Klien</th>
                                            <td><b><?= htmlspecialchars($data['nama_lengkap'] ?? '-') ?></b></td>
                                        </tr>
                                        <tr>
                                            <th>Bank Tujuan</th>
                                            <td><?= htmlspecialchars($data['nama_bank'] ?? '-') ?></td>
                                        </tr>
                                        <tr>
                                            <th>Atas Nama</th>
                                            <td><?= htmlspecialchars($data['atas_nama'] ?? '-') ?></td>
                                        </tr>
                                        <tr>
                                            <th>Nomor Rekening</th>
                                            <td><?= htmlspecialchars($data['no_rek'] ?? '-') ?></td>
                                        </tr>
                                        <tr>
                                            <th>Bukti Pembayaran</th>
                                            <td>
                                                <?php if (!empty($data['file_bukti_pembayaran'])): ?>
                                                    <a href="<?= htmlspecialchars($data['file_bukti_pembayaran']) ?>" target="_blank">
                                                        <img src="<?= htmlspecialchars($data['file_bukti_pembayaran']) ?>" class="thumb" alt="Bukti"/>
                                                    </a>
                                                <?php else: ?>
                                                    <span class="text-muted">Belum ada bukti.</span>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                                <div class="col-md-6">
                                    <form action="" method="POST">
                                        <div class="form-group">
                                            <label for="ket">Keterangan</label>
                                            <input type="text" id="ket" name="keterangan" class="form-control" placeholder="Opsional…">
                                        </div>
                                        <div class="d-flex mt-2" style="gap:.5rem">
                                            <button type="submit" name="verifikasi" value="tolak" class="btn btn-danger">
                                                Tolak
                                            </button>
                                            <button type="submit" name="verifikasi" value="verifikasi" class="btn btn-success">
                                                Verifikasi
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div> <!-- /row -->
                        </div>
                    </div>
                <?php endif; ?>
            </div> <!-- /row -->
        </div> <!-- /container -->
    </section>
</div>

<script>
document.getElementById('btn-print')?.addEventListener('click', function(){ window.print(); });
</script>
