<?php
// ---- Helpers untuk state menu yang lebih rapi ----
function g($key, $default = '') { return isset($_GET[$key]) ? $_GET[$key] : $default; }
function isActive($pages) {
    $p = g('page');
    if (is_array($pages)) return in_array($p, $pages) ? 'active' : '';
    return ($p === $pages) ? 'active' : '';
}
function isOpen($pages) {
    $p = g('page');
    return in_array($p, $pages) ? 'menu-open' : '';
}

// ---- Query badge dinamis ----
$query = "SELECT COUNT(*) AS jml FROM tb_pengajuan WHERE status='Pending'";
$result = $conn->query($query);
$pengajuan = $result->fetch_assoc();

$query = "SELECT COUNT(*) AS jml FROM tb_pembayaran WHERE status='Menunggu Verifikasi'";
$result = $conn->query($query);
$pembayaran = $result->fetch_assoc();

// ---- Kumpulan halaman untuk group menu ----
$masterPages = ['detail_konsep','detail_produksi','detail_talent','detail_equipment','jabatan','bank','konsep','produksi','equipment','talent','tambah_konsep','tambah_bank','tambah_jabatan','tambah_produksi','tambah_equipment','tambah_talent','edit_konsep','edit_bank','edit_produksi','edit_jabatan','edit_equipment','edit_talent'];
$processPages = ['pembayaran','tambah_pembayaran','pengajuan','detail_pengajuan','edit_pengajuan','jadwal_meeting','tambah_jadwal_meeting','edit_jadwal_meeting','anggaran','tambah_anggaran'];
$reportPages  = ['laporan_klien','laporan_pembayaran','laporan_karyawan','laporan_konsep','laporan_produksi','laporan_equipment','laporan_talent','laporan_pengajuan','laporan_anggaran'];
$homePages    = ['paket_wedding','tambah_paket_wedding','edit_paket_wedding','caraousel','tambah_caraousel','edit_caraousel','tambah_hasil_kerja','edit_hasil_kerja','profil','alasan_pengguna','kelebihan','hasil_kerja'];
$vendorPages  = ['profil_vendor','vendor_terbaik'];
$crewPages    = ['profil_crew'];
?>

<!-- Main Sidebar Container -->
<aside class="main-sidebar sidebar-dark-primary elevation-4" aria-label="Sidebar utama">
  <!-- Brand Logo -->
  <a href="index.php" class="brand-link d-flex align-items-center gap-2 px-3">
    <img src="assets/img/logo1.png" alt="Logo" class="brand-image" />
    <!-- <span class="brand-text font-weight-light d-none d-lg-inline">ProJasa</span> -->

    <!-- Toggle sidebar di mobile (di header) -->
    <button class="btn btn-sm btn-outline-light ms-auto d-lg-none" type="button" data-widget="pushmenu" aria-label="Toggle sidebar" aria-controls="adminlteSidebar" aria-expanded="false">
      <i class="fas fa-bars"></i>
    </button>
  </a>

  <!-- Sidebar -->
  <div id="adminlteSidebar" class="sidebar">
    <!-- User panel -->
    <div class="user-panel d-flex align-items-center my-3 pb-3 border-bottom border-secondary">
      <div class="image me-2">
        <!-- <img src="assets/img/sy.png" class="img-circle elevation-2" style="height:40px; width:40px; object-fit:cover;" alt="User"> -->
        <div class="avatar-fallback text-uppercase"><?= substr($_SESSION['level'] ?? 'U',0,1); ?></div>
      </div>
      <div class="info">
        <a href="#" class="d-block" title="Level pengguna"><?= htmlspecialchars($_SESSION['level'] ?? 'User'); ?></a>
      </div>
    </div>

    <!-- Pencarian (opsional) -->
    <div class="form-inline sidebar-search mb-2">
      <div class="input-group" data-widget="sidebar-search">
        <input class="form-control form-control-sidebar" type="search" placeholder="Cari menu..." aria-label="Cari menu" />
        <div class="input-group-append">
          <button class="btn btn-sidebar" aria-label="Cari">
            <i class="fas fa-search fa-fw"></i>
          </button>
        </div>
      </div>
    </div>

    <!-- Sidebar Menu -->
    <nav class="mt-2 pb-4">
      <ul class="nav nav-pills nav-sidebar flex-column js-close-on-mobile" data-widget="treeview" role="menu" data-accordion="false">
        <!-- Dashboard -->
        <li class="nav-item">
          <a href="index.php" class="nav-link <?= g('page') === '' ? 'active' : ''; ?>" aria-current="<?= g('page') === '' ? 'page' : 'false'; ?>">
            <i class="nav-icon fas fa-home"></i>
            <p>Dashboard</p>
          </a>
        </li>

        <!-- Data Karyawan -->
        <li class="nav-item">
          <a href="?page=karyawan" class="nav-link <?= isActive(['karyawan','tambah_karyawan','edit_karyawan']); ?>">
            <i class="nav-icon fa fa-users" aria-hidden="true"></i>
            <p>Data Karyawan</p>
          </a>
        </li>

        <!-- Data Klien -->
        <li class="nav-item">
          <a href="?page=klien" class="nav-link <?= isActive(['klien','tambah_klien','edit_klien']); ?>">
            <i class="nav-icon fa fa-user-friends" aria-hidden="true"></i>
            <p>Data Klien</p>
          </a>
        </li>

        <!-- Master Data -->
        <li class="nav-item <?= isOpen($masterPages); ?>">
          <a href="#" class="nav-link <?= isActive($masterPages); ?>">
            <i class="nav-icon far fa-folder"></i>
            <p>Master Data<i class="right fas fa-angle-left"></i></p>
          </a>
          <ul class="nav nav-treeview">
            <li class="nav-item"><a href="?page=bank" class="nav-link <?= isActive(['bank','tambah_bank','edit_bank']); ?>"><i class="far fa-circle nav-icon"></i><p>Bank</p></a></li>
            <li class="nav-item"><a href="?page=jabatan" class="nav-link <?= isActive(['jabatan','tambah_jabatan','edit_jabatan']); ?>"><i class="far fa-circle nav-icon"></i><p>Jabatan</p></a></li>
            <li class="nav-item"><a href="?page=konsep" class="nav-link <?= isActive(['detail_konsep','konsep','tambah_konsep','edit_konsep']); ?>"><i class="far fa-circle nav-icon"></i><p>Pengurusan</p></a></li>
            <li class="nav-item"><a href="?page=produksi" class="nav-link <?= isActive(['detail_produksi','produksi','tambah_produksi','edit_produksi']); ?>"><i class="far fa-circle nav-icon"></i><p>Layanan</p></a></li>
            <!-- <li class="nav-item"><a href="?page=equipment" class="nav-link <?= isActive(['detail_equipment','equipment','tambah_equipment','edit_equipment']); ?>"><i class="far fa-circle nav-icon"></i><p>Equipment</p></a></li> -->
            <!-- <li class="nav-item"><a href="?page=talent" class="nav-link <?= isActive(['detail_talent','talent','tambah_talent','edit_talent']); ?>"><i class="far fa-circle nav-icon"></i><p>Talent</p></a></li> -->
          </ul>
        </li>

        <!-- Proses Data -->
        <li class="nav-item <?= isOpen($processPages); ?>">
          <a href="#" class="nav-link <?= isActive($processPages); ?>">
            <i class="nav-icon fas fa-retweet"></i>
            <p>
              Proses Data
              <span class="right badge badge-info ms-2"><?= (int)$pengajuan['jml'] + (int)$pembayaran['jml']; ?></span>
              <i class="fas fa-angle-left right"></i>
            </p>
          </a>
          <ul class="nav nav-treeview">
            <li class="nav-item">
              <a href="?page=pengajuan" class="nav-link <?= isActive(['pengajuan','edit_pengajuan','detail_pengajuan']); ?>">
                <i class="far fa-circle nav-icon"></i>
                <p>Pengajuan <span class="badge badge-warning ml-1"><?= (int)$pengajuan['jml']; ?></span></p>
              </a>
            </li>
            <li class="nav-item">
              <a href="?page=jadwal_meeting" class="nav-link <?= isActive(['jadwal_meeting','tambah_jadwal_meeting','edit_jadwal_meeting']); ?>">
                <i class="far fa-circle nav-icon"></i><p>Jadwal Meeting</p>
              </a>
            </li>
            <li class="nav-item">
              <a href="?page=anggaran" class="nav-link <?= isActive(['anggaran','tambah_anggaran']); ?>">
                <i class="far fa-circle nav-icon"></i><p>Anggaran</p>
              </a>
            </li>
            <li class="nav-item">
              <a href="?page=pembayaran" class="nav-link <?= isActive(['pembayaran','tambah_pembayaran']); ?>">
                <i class="far fa-circle nav-icon"></i>
                <p>Pembayaran <span class="badge badge-warning ml-1"><?= (int)$pembayaran['jml']; ?></span></p>
              </a>
            </li>
          </ul>
        </li>

        <!-- Laporan -->
        <li class="nav-item <?= isOpen($reportPages); ?>">
          <a href="#" class="nav-link <?= isActive($reportPages); ?>">
            <i class="nav-icon fas fa-clipboard-list"></i>
            <p>Laporan<i class="fas fa-angle-left right"></i></p>
          </a>
          <ul class="nav nav-treeview">
            <li class="nav-item"><a href="?page=laporan_klien" class="nav-link <?= isActive('laporan_klien'); ?>"><i class="far fa-circle nav-icon"></i><p>Klien</p></a></li>
            <li class="nav-item"><a href="?page=laporan_karyawan" class="nav-link <?= isActive('laporan_karyawan'); ?>"><i class="far fa-circle nav-icon"></i><p>Karyawan</p></a></li>
            <li class="nav-item"><a href="?page=laporan_konsep" class="nav-link <?= isActive('laporan_konsep'); ?>"><i class="far fa-circle nav-icon"></i><p>Pengurusan</p></a></li>
            <li class="nav-item"><a href="?page=laporan_produksi" class="nav-link <?= isActive('laporan_produksi'); ?>"><i class="far fa-circle nav-icon"></i><p>Layanan</p></a></li>
            <li class="nav-item"><a href="?page=laporan_pengajuan" class="nav-link <?= isActive('laporan_pengajuan'); ?>"><i class="far fa-circle nav-icon"></i><p>Pengajuan</p></a></li>
            <li class="nav-item"><a href="?page=laporan_anggaran" class="nav-link <?= isActive('laporan_anggaran'); ?>"><i class="far fa-circle nav-icon"></i><p>Anggaran</p></a></li>
            <li class="nav-item"><a href="?page=laporan_pembayaran" class="nav-link <?= isActive('laporan_pembayaran'); ?>"><i class="far fa-circle nav-icon"></i><p>Pembayaran</p></a></li>
          </ul>
        </li>

        <!-- Portfolio: Home -->
        <li class="nav-header">PORTFOLIO</li>
        <li class="nav-item <?= isOpen($homePages); ?>">
          <a href="#" class="nav-link <?= isActive($homePages); ?>">
            <i class="nav-icon fas fa-desktop"></i>
            <p>Home<i class="right fas fa-angle-left"></i></p>
          </a>
          <ul class="nav nav-treeview">
            <li class="nav-item"><a href="?page=caraousel" class="nav-link <?= isActive(['caraousel','tambah_caraousel','edit_caraousel']); ?>"><i class="far fa-circle nav-icon"></i><p>Carousel</p></a></li>
            <li class="nav-item"><a href="?page=profil" class="nav-link <?= isActive(['profil']); ?>"><i class="far fa-circle nav-icon"></i><p>Profil</p></a></li>
            <li class="nav-item"><a href="?page=alasan_pengguna" class="nav-link <?= isActive(['alasan_pengguna']); ?>"><i class="far fa-circle nav-icon"></i><p>Alasan Pengguna</p></a></li>
            <li class="nav-item"><a href="?page=kelebihan" class="nav-link <?= isActive(['kelebihan']); ?>"><i class="far fa-circle nav-icon"></i><p>Kelebihan</p></a></li>
            <li class="nav-item"><a href="?page=paket_wedding" class="nav-link <?= isActive(['paket_wedding','tambah_paket_wedding','edit_paket_wedding']); ?>"><i class="far fa-circle nav-icon"></i><p>Paket Jasa Kami</p></a></li>
            <li class="nav-item"><a href="?page=hasil_kerja" class="nav-link <?= isActive(['hasil_kerja','tambah_hasil_kerja','edit_hasil_kerja']); ?>"><i class="far fa-circle nav-icon"></i><p>Hasil Kerja</p></a></li>
          </ul>
        </li>
        
        <!-- Vendor 
        <li class="nav-item <?= isOpen($vendorPages); ?>">
          <a href="#" class="nav-link <?= isActive($vendorPages); ?>">
            <i class="nav-icon fab fa-battle-net"></i>
            <p>Vendor<i class="right fas fa-angle-left"></i></p>
          </a>
          <ul class="nav nav-treeview">
            <li class="nav-item"><a href="?page=profil_vendor" class="nav-link <?= isActive(['profil_vendor']); ?>"><i class="far fa-circle nav-icon"></i><p>Profil</p></a></li>
            <li class="nav-item"><a href="?page=vendor_terbaik" class="nav-link <?= isActive(['vendor_terbaik']); ?>"><i class="far fa-circle nav-icon"></i><p>Vendor Terbaik</p></a></li>
          </ul>
        </li>-->

        <!-- Crew -->
        <li class="nav-item <?= isOpen($crewPages); ?>">
          <a href="#" class="nav-link <?= isActive($crewPages); ?>">
            <i class="nav-icon fas fa-user-tie"></i>
            <p>Crew<i class="right fas fa-angle-left"></i></p>
          </a>
          <ul class="nav nav-treeview">
            <li class="nav-item"><a href="?page=profil_crew" class="nav-link <?= isActive(['profil_crew']); ?>"><i class="far fa-circle nav-icon"></i><p>Profil</p></a></li>
          </ul>
        </li>

      </ul>
    </nav>
    <!-- /.sidebar-menu -->

    <!-- Footer aksi cepat (opsional) -->
    <div class="sidebar-footer d-none d-lg-flex gap-2 px-3 pb-3">
      <!-- <a href="logout.php" class="btn btn-sm btn-outline-light w-100"><i class="fas fa-sign-out-alt me-1"></i> Logout</a> -->
    </div>
  </div>
  <!-- /.sidebar -->
</aside>

<!-- ==== Floating Toggle hanya di Mobile ==== -->
<button
  id="sidebarFab"
  type="button"
  class="btn btn-primary shadow rounded-circle d-lg-none"
  data-widget="pushmenu"
  aria-label="Toggle menu"
  aria-controls="adminlteSidebar"
  aria-expanded="false"
  style="position: fixed; left: 16px; bottom: 16px; width: 48px; height: 48px; z-index: 1050; display: none;">
  <i class="fas fa-bars"></i>
</button>

<!-- ==== Styling tambahan agar elegan & responsif ==== -->
<style>
  .main-sidebar { position: sticky; top: 0; height: 100vh; backdrop-filter: saturate(120%) blur(2px); }
  .brand-link { min-height: 56px; }
  .brand-link .brand-image { max-height: 36px; width: auto; object-fit: contain; filter: drop-shadow(0 1px 1px rgba(0,0,0,.25)); }
  .avatar-fallback{
    height:40px;width:40px;border-radius:50%;
    display:grid;place-items:center;
    background:linear-gradient(135deg,#3b82f6,#06b6d4);
    color:#fff;font-weight:700;
    box-shadow:0 2px 6px rgba(0,0,0,.25);
  }
  .sidebar { overflow-y: auto; }
  .sidebar::-webkit-scrollbar{ width:8px; }
  .sidebar::-webkit-scrollbar-thumb{ background: rgba(255,255,255,.25); border-radius: 8px; }
  .nav-sidebar .nav-item > .nav-link { border-radius: .5rem; margin: 2px 8px; transition: background .2s, transform .05s; }
  .nav-sidebar .nav-item > .nav-link:hover { background: rgba(255,255,255,.07); }
  .nav-sidebar .nav-item > .nav-link:focus { outline: 2px solid rgba(255,255,255,.25); outline-offset: 2px; }
  .nav-sidebar .nav-item > .nav-link.active{ background: linear-gradient(135deg,#2563eb,#0ea5e9) !important; box-shadow: 0 6px 16px rgba(14,165,233,.25); }
  .nav-sidebar .nav-treeview .nav-link.active{ background: rgba(59,130,246,.18) !important; }
  .nav-sidebar .nav-item .right.badge { font-weight:600; }
  .nav-header { letter-spacing: .08em; font-size: .74rem; opacity: .8; margin: 10px 16px 6px; }

  /* Tampilkan FAB hanya di layar <= 992px */
  @media (max-width: 992px){
    #sidebarFab { display: inline-flex !important; align-items: center; justify-content: center; }
    .brand-text{ display:none !important; }
    .nav-sidebar .nav-item > .nav-link{ margin: 2px 6px; }
  }
</style>

<!-- ==== Script: auto-collapse & close on link click (mobile) ==== -->
<script>
  (function () {
    const isMobile = () => window.matchMedia('(max-width: 992px)').matches;
    const body = document.body;
    const fab = document.getElementById('sidebarFab');

    // Pastikan saat load di mobile, sidebar dalam keadaan collapsed (tutup)
    function ensureCollapsedOnMobile() {
      if (isMobile()) {
        body.classList.add('sidebar-collapse');
      } else {
        body.classList.remove('sidebar-collapse');
      }
    }

    // Auto close ketika klik link sidebar di mobile
    function bindAutoCloseOnClick() {
      const container = document.querySelector('.js-close-on-mobile');
      if (!container) return;
      container.addEventListener('click', function (e) {
        const link = e.target.closest('a.nav-link');
        if (!link) return;
        // Biarkan link jalan, tapi sembari collapse (UX seperti drawer)
        if (isMobile()) {
          // AdminLTE 3/4 menggunakan class ini untuk toggle
          body.classList.add('sidebar-collapse');
        }
      }, { capture: true });
    }

    // Update aria-expanded pada tombol (aksesibilitas)
    function updateAriaExpanded() {
      const expanded = !body.classList.contains('sidebar-collapse');
      const btns = document.querySelectorAll('[data-widget="pushmenu"]');
      btns.forEach(b => b.setAttribute('aria-expanded', String(expanded)));
    }

    // Observasi perubahan class body (saat pushmenu dipakai)
    const obs = new MutationObserver(updateAriaExpanded);
    obs.observe(body, { attributes: true, attributeFilter: ['class'] });

    // Init
    ensureCollapsedOnMobile();
    bindAutoCloseOnClick();
    updateAriaExpanded();

    window.addEventListener('resize', ensureCollapsedOnMobile);
  })();
</script>
