<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>ProJasa</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="assets/plugins/fontawesome-free/css/all.min.css">
    <!-- Animate.css -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>

    <style>
        /* Background body berwarna animasi */
        body {
            margin: 0;
            font-family: Arial, sans-serif;
            background: linear-gradient(-45deg, #ff5100, #ff9f1c, #2ec4b6, #6c63ff);
            background-size: 400% 400%;
            animation: gradientBG 15s ease infinite;
            min-height: 100vh;
            color: #212529;
        }
        @keyframes gradientBG {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }

        .map-container {
            aspect-ratio: 16/9;
            max-height: 250px;
        }
        .map-container iframe {
            width: 100%;
            height: 100%;
            border: none;
        }
        #footer img {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        #footer img:hover {
            transform: scale(1.05);
            box-shadow: 0 4px 15px rgba(0,0,0,0.3);
        }

        /* Sub-bagian berwarna footer */
        .footer-box {
            padding: 15px;
            border-radius: 8px;
        }
        .bg-gradient-orange {
            background: linear-gradient(135deg, rgba(255, 81, 0, 0.8), rgba(255, 150, 50, 0.7));
        }
        .bg-gradient-blue {
            background: linear-gradient(135deg, rgba(0, 123, 255, 0.8), rgba(100, 180, 255, 0.7));
        }
        .bg-gradient-green {
            background: linear-gradient(135deg, rgba(40, 167, 69, 0.8), rgba(100, 220, 150, 0.7));
        }
        .bg-gradient-purple {
            background: linear-gradient(135deg, rgba(111, 66, 193, 0.8), rgba(180, 120, 255, 0.7));
        }

        /* Tombol Back to Top */
        #backToTop {
            position: fixed;
            bottom: 30px;
            right: 30px;
            display: none;
            z-index: 999;
            width: 45px;
            height: 45px;
            background-color: #ff5100;
            border: none;
        }
        #backToTop:hover {
            background-color: #e64900;
        }
    </style>
</head>

<body>

    <!-- Isi konten utama -->
    <div class="container py-5 text-center text-white">
        <h1 class="fw-bold animate__animated animate__fadeInDown">Selamat Datang di ProJasa</h1>
        <p class="lead animate__animated animate__fadeInUp">Melayani jasa perizinan & konsultasi profesional</p>
    </div>

    <!-- Footer -->
    <footer id="footer" class="container-fluid text-white bg-dark pt-5 mt-5">
        <div class="row justify-content-center px-5 g-3">

            <!-- Kontak -->
            <div class="col-md-3 mb-4 text-start animate__animated animate__fadeInLeft footer-box bg-gradient-orange">
                <h5 class="fw-bold mb-3">Kontak</h5>
                <p class="mb-2">
                    <i class="fas fa-envelope me-2"></i>
                    <span>support@projasa.co.id</span>
                </p>
                <p class="mb-3">
                    <i class="fas fa-phone me-2"></i>
                    <span>0361 4742453</span>
                </p>
                <a href="https://wa.me/628125532111" target="_blank" 
                class="btn btn-success btn-sm d-inline-flex align-items-center shadow-sm">
                    <i class="fab fa-whatsapp me-2 fs-5"></i> Chat via WhatsApp
                </a>

                <h5 class="fw-bold mt-4 mb-3">Sosial Media</h5>
                <p>
                    <i class="fab fa-instagram me-2"></i>
                    <a href="https://www.instagram.com/7ingga.kreatif/" target="_blank" class="text-white text-decoration-none">
                        Instagram
                    </a>
                </p>
            </div>

            <!-- Alamat -->
            <div class="col-md-3 mb-4 text-start animate__animated animate__fadeInUp animate__delay-1s footer-box bg-gradient-blue">
                <h5 class="fw-bold mb-3">Alamat</h5>
                <p class="text-justify">
                    Projasa Jl. Pulau Batanta No.18 B,<br>
                    Dauh Puri Kauh, Kec. Denpasar Bar.,<br>
                    Kota Denpasar, Bali 80114
                </p>
            </div>

            <!-- Lokasi -->
            <div class="col-md-3 mb-4 text-start animate__animated animate__fadeInUp animate__delay-2s footer-box bg-gradient-green">
                <h5 class="fw-bold mb-3">Lokasi</h5>
                <div class="map-container position-relative rounded overflow-hidden shadow-lg">
                    <iframe 
                        src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d7888.186608145828!2d115.200131!3d-8.682677!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x2dd240b7e576a36b%3A0xa7b8aab81bc4e!2sProjasa!5e0!3m2!1sen!2sid!4v1758349998607!5m2!1sen!2sid" 
                        style="border:0;" allowfullscreen="" loading="lazy">
                    </iframe>
                </div>
            </div>

            <!-- Jenis Pembayaran -->
            <div class="col-md-3 mb-4 text-start animate__animated animate__fadeInRight animate__delay-3s footer-box bg-gradient-purple">
                <h5 class="fw-bold mb-3">Jenis Pembayaran</h5>
                <div class="row g-3">
                    <div class="col-6">
                        <img src="assets/img/bca.jpg" alt="BCA" class="img-fluid rounded shadow-sm">
                    </div>
                    <div class="col-6">
                        <img src="assets/img/bni.png" alt="BNI" class="img-fluid rounded shadow-sm">
                    </div>
                    <div class="col-6">
                        <img src="assets/img/bri.png" alt="BRI" class="img-fluid rounded shadow-sm">
                    </div>
                    <div class="col-6">
                        <img src="assets/img/mandiri.png" alt="Mandiri" class="img-fluid rounded shadow-sm">
                    </div>
                </div>
            </div>
        </div>

        <hr class="border-light">

        <div class="text-center pb-3 animate__animated animate__fadeInUp animate__delay-4s">
            <small>&copy; <?= date('Y') ?> ProJasa. All rights reserved.</small>
        </div>
    </footer>

    <!-- Tombol Panah ke Atas -->
    <button id="backToTop" class="btn btn-primary rounded-circle shadow">
        <i class="fas fa-arrow-up"></i>
    </button>

    <!-- Script -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        const backToTop = document.getElementById("backToTop");

        window.addEventListener("scroll", () => {
            backToTop.style.display = (window.scrollY > 300) ? "block" : "none";
        });

        backToTop.addEventListener("click", () => {
            window.scrollTo({ top: 0, behavior: 'smooth' });
        });
    </script>
</body>
</html>
