<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">

                    <div class="card mt-3">
                        <div class="card-header">
                            <div class="row">
                                <div class="col d-flex align-items-center">
                                    <h4 class="font-weight-bold">Laporan Grafik Pengurusan</h4>
                                </div>
                                <div class="col-auto">
                                    <form action="" method="POST">
                                        <div class="row">
                                            <div class="col-auto d-flex align-items-center">
                                                Tahun:
                                            </div>
                                            <div class="col">
                                                <input type="number" class="form-control" name="tahun"
                                                       value="<?= isset($_POST['filter']) ? (int)$_POST['tahun'] : (int)date('Y') ?>">
                                            </div>
                                            <div class="col-auto">
                                                <button type="submit" name="filter" class="btn btn-secondary">Filter</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <div class="card-body">
                            <div class="chart">
                                <canvas id="barChart" style="min-height: 250px; height: 550px; max-height: 550px; max-width: 100%;"></canvas>
                            </div>
                        </div>

                        <div class="card-footer">
                            <?php if (isset($_POST['filter'])) : ?>
                                <a href="laporan/konsep.php?tahun=<?= (int)$_POST['tahun'] ?>" class="btn btn-primary float-right" target="_blank">Cetak</a>
                            <?php else : ?>
                                <a href="laporan/konsep.php" class="btn btn-primary float-right" target="_blank">Cetak</a>
                            <?php endif; ?>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </section>
</div>

<?php
// ====== Ambil tahun ======
$tahun = isset($_POST['filter']) ? (int)$_POST['tahun'] : (int)date('Y');

// ====== Peta konsep (id => nama) ======
$konsepMap = [];
$resKonsep = $conn->query("SELECT id, nama FROM tb_konsep ORDER BY nama ASC");
if ($resKonsep) {
    while ($r = $resKonsep->fetch_assoc()) {
        $konsepMap[(int)$r['id']] = $r['nama'];
    }
}

// Siapkan matriks data 12 bulan nol untuk semua konsep
$dataKonsep = [];
foreach ($konsepMap as $kid => $nama) {
    $dataKonsep[$kid] = array_fill(1, 12, 0);
}

// ====== Satu query: total per bulan per konsep (status Disetujui) ======
$sql = "
    SELECT p.konsep AS id_konsep, MONTH(p.tanggal_pengajuan) AS m, COUNT(*) AS jml
    FROM tb_pengajuan p
    WHERE p.status='Disetujui' AND YEAR(p.tanggal_pengajuan)={$tahun}
    GROUP BY p.konsep, MONTH(p.tanggal_pengajuan)
";
$res = $conn->query($sql);
if ($res) {
    while ($row = $res->fetch_assoc()) {
        $kid = (int)$row['id_konsep'];
        $m   = (int)$row['m'];
        $cnt = (int)$row['jml'];
        if (isset($dataKonsep[$kid]) && $m>=1 && $m<=12) {
            $dataKonsep[$kid][$m] = $cnt;
        }
    }
}

// Bangun datasets untuk Chart.js
$datasets = [];
foreach ($konsepMap as $kid => $nama) {
    $datasets[] = [
        'label' => $nama,
        'data'  => array_values($dataKonsep[$kid])
    ];
}

// Label bulan (pakai yang sudah dipakai di halaman ini)
$labelsBulan = ['January','February','March','April','May','June','July','Agustus','September','Oktober','November','Desember'];
?>

<script>
$(function() {
    // ====== Data dari PHP ======
    var labelsBulan = <?= json_encode($labelsBulan) ?>;
    var phpDatasets = <?= json_encode($datasets, JSON_UNESCAPED_UNICODE) ?>;

    // Utility warna (tetap kompatibel dengan Chart.js v2)
    function randColor(alpha) {
        alpha = alpha || 0.9;
        var r = Math.floor(Math.random()*200)+30;
        var g = Math.floor(Math.random()*200)+30;
        var b = Math.floor(Math.random()*200)+30;
        return {
            bg: 'rgba(' + r + ',' + g + ',' + b + ',' + alpha + ')',
            bd: 'rgba(' + Math.max(0,r-25) + ',' + Math.max(0,g-25) + ',' + Math.max(0,b-25) + ',1)'
        };
    }

    // Build datasets Chart.js
    var chartDatasets = phpDatasets.map(function(ds) {
        var c = randColor(0.85);
        return {
            label: ds.label,
            data: ds.data.map(function(v){ return parseInt(v||0); }),
            backgroundColor: c.bg,
            borderColor: c.bd,
            borderWidth: 1.5
        };
    });

    // Area/Bar data (v2 style)
    var areaChartData = {
        labels: labelsBulan,
        datasets: chartDatasets
    };

    // Opsi chart (Chart.js v2)
    var barChartOptions = {
        responsive: true,
        maintainAspectRatio: false,
        datasetFill: false,
        legend: { display: true, position: 'bottom' },
        tooltips: {
            callbacks: {
                label: function(item, data) {
                    var label = data.datasets[item.datasetIndex].label || '';
                    var val = item.yLabel;
                    return label + ': ' + val;
                }
            }
        },
        scales: {
            xAxes: [{
                gridLines: { display: false }
            }],
            yAxes: [{
                ticks: {
                    beginAtZero: true,
                    // tampilkan hanya bilangan bulat
                    callback: function(value) { if (value % 1 === 0) return value; }
                },
                gridLines: { display: false }
            }]
        }
    };

    var barChartCanvas = $('#barChart').get(0).getContext('2d');
    var barChartData = $.extend(true, {}, areaChartData);

    new Chart(barChartCanvas, {
        type: 'bar',
        data: barChartData,
        options: barChartOptions
    });
});
</script>
