<?php
if (!isset($conn)) { die("Koneksi belum tersedia"); }
if (session_status() === PHP_SESSION_NONE) { session_start(); }

$tahun = isset($_GET['tahun']) ? (int)$_GET['tahun'] : (int)date('Y');

// ----- KARTU RINGKAS -----
$pending = 0;
if (isset($_SESSION['level']) && $_SESSION['level'] === 'ADMIN') {
    $res = $conn->query("SELECT COUNT(*) AS c FROM tb_pengajuan WHERE status='Pending'");
    $pending = (int)($res ? $res->fetch_assoc()['c'] : 0);
}

// Total Klien
$res = $conn->query("SELECT COUNT(*) AS c FROM tb_klien");
$totalKlien = (int)($res ? $res->fetch_assoc()['c'] : 0);

// Total Karyawan
$res = $conn->query("SELECT COUNT(*) AS c FROM tb_karyawan");
$totalKaryawan = (int)($res ? $res->fetch_assoc()['c'] : 0);

// Total Layanan (tb_produksi) untuk jenis setelah refaktor
$res = $conn->query("SELECT COUNT(*) AS c FROM tb_produksi WHERE jenis IN ('PERIZINAN','MAN POWER')");
$totalLayanan = (int)($res ? $res->fetch_assoc()['c'] : 0);

// ----- DISTRIBUSI STATUS -----
$stPending = $stDisetujui = $stDitolak = 0;
$res = $conn->query("SELECT status, COUNT(*) AS c FROM tb_pengajuan GROUP BY status");
if ($res) {
    while ($r = $res->fetch_assoc()) {
        if ($r['status'] === 'Pending')    $stPending    = (int)$r['c'];
        if ($r['status'] === 'Disetujui')  $stDisetujui  = (int)$r['c'];
        if ($r['status'] === 'Ditolak')    $stDitolak    = (int)$r['c'];
    }
}

// ----- GRAFIK BULANAN PER KONSEP/LAYANAN (tb_konsep) -----
$mapKonsep = [];          // id => nama
$res = $conn->query("SELECT id, nama FROM tb_konsep ORDER BY nama ASC");
while ($res && $row = $res->fetch_assoc()) {
    $mapKonsep[(int)$row['id']] = $row['nama'];
}

// Siapkan matriks 12 bulan
$seriesKonsep = []; // id => [1..12] => 0
foreach ($mapKonsep as $kid => $_) {
    $seriesKonsep[$kid] = array_fill(1, 12, 0);
}

// Agregasi jumlah disetujui per konsep per bulan (tahun terpilih)
if (!empty($mapKonsep)) {
    $res = $conn->query("
        SELECT konsep AS id_konsep, MONTH(tanggal_pengajuan) AS m, COUNT(*) AS jml
        FROM tb_pengajuan
        WHERE status='Disetujui' AND YEAR(tanggal_pengajuan)={$tahun}
        GROUP BY konsep, MONTH(tanggal_pengajuan)
    ");
    while ($res && $row = $res->fetch_assoc()) {
        $kid = (int)$row['id_konsep']; $m = (int)$row['m']; $cnt = (int)$row['jml'];
        if (isset($seriesKonsep[$kid]) && $m>=1 && $m<=12) {
            $seriesKonsep[$kid][$m] = $cnt;
        }
    }
}

// Susun datasets Chart.js
$datasetsKonsep = [];
foreach ($mapKonsep as $kid => $nama) {
    $datasetsKonsep[] = [
        'label' => $nama,
        'data'  => array_values($seriesKonsep[$kid]),
    ];
}

// ----- PENGAJUAN TERBARU -----
$limit = 8;
if (isset($_SESSION['level']) && $_SESSION['level'] === 'KLIEN') {
    $idKlien = (int)($_SESSION['id_klien'] ?? 0);
    $sqlLatest = "
        SELECT p.id, p.tanggal_pengajuan, p.status, k.nama_lengkap,
               (SELECT nama FROM tb_konsep WHERE id=p.konsep) AS konsep
        FROM tb_pengajuan p
        INNER JOIN tb_klien k ON p.id_klien=k.id
        WHERE k.id={$idKlien}
        ORDER BY p.tanggal_pengajuan DESC
        LIMIT {$limit}";
} else {
    $sqlLatest = "
        SELECT p.id, p.tanggal_pengajuan, p.status, k.nama_lengkap,
               (SELECT nama FROM tb_konsep WHERE id=p.konsep) AS konsep
        FROM tb_pengajuan p
        INNER JOIN tb_klien k ON p.id_klien=k.id
        ORDER BY p.tanggal_pengajuan DESC
        LIMIT {$limit}";
}
$resLatest = $conn->query($sqlLatest);
$latestRows = $resLatest ? $resLatest->fetch_all(MYSQLI_ASSOC) : [];

$labelsBulan = ['January','February','March','April','May','June','July','Agustus','September','Oktober','November','Desember'];
?>
<div class="content-wrapper">

    <!-- Header -->
    <div class="content-header pb-0">
        <div class="container-fluid">
            <div class="row mb-2 align-items-center">
                <div class="col-12 col-lg-8">
                    <h4 class="m-0">
                        <?php if (($_SESSION['level'] ?? '') === 'ADMIN'): ?>
                            Selamat Datang, Administrator 👋
                        <?php else: ?>
                            Selamat Datang, <?= htmlspecialchars($_SESSION['nama'] ?? 'Pengguna') ?> 👋
                        <?php endif; ?>
                    </h4>
                    <div class="text-muted">Ringkasan kinerja & aktivitas layanan tahun <b><?= $tahun ?></b></div>
                </div>
                <div class="col-12 col-lg-4 mt-3 mt-lg-0">
                    <form method="get" class="d-flex justify-content-lg-end">
                        <label class="mr-2 mb-0 d-flex align-items-center">Tahun</label>
                        <input type="number" name="tahun" class="form-control" value="<?= $tahun ?>" style="max-width: 140px;">
                        <button class="btn btn-primary ml-2">Terapkan</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Body -->
    <section class="content">
        <div class="container-fluid">

            <!-- Kartu Ringkas -->
            <div class="row">
                <?php if (($_SESSION['level'] ?? '') === 'ADMIN'): ?>
                <div class="col-12 col-sm-6 col-lg-3">
                    <div class="small-box bg-info">
                        <div class="inner">
                            <h3><?= number_format($pending) ?></h3>
                            <p>Pengajuan Baru (Pending)</p>
                        </div>
                        <div class="icon"><i class="fa fa-paper-plane"></i></div>
                    </div>
                </div>
                <?php endif; ?>

                <div class="col-12 col-sm-6 col-lg-3">
                    <div class="small-box bg-success">
                        <div class="inner">
                            <h3><?= number_format($totalKlien) ?></h3>
                            <p>Jumlah Klien</p>
                        </div>
                        <div class="icon"><i class="fa fa-users"></i></div>
                    </div>
                </div>

                <div class="col-12 col-sm-6 col-lg-3">
                    <div class="small-box bg-warning">
                        <div class="inner">
                            <h3><?= number_format($totalKaryawan) ?></h3>
                            <p>Jumlah Karyawan</p>
                        </div>
                        <div class="icon"><i class="fas fa-user-tie"></i></div>
                    </div>
                </div>

                <div class="col-12 col-sm-6 col-lg-3">
                    <div class="small-box bg-danger">
                        <div class="inner">
                            <h3><?= number_format($totalLayanan) ?></h3>
                            <p>Total Layanan Aktif</p>
                        </div>
                        <div class="icon"><i class="fas fa-briefcase"></i></div>
                    </div>
                </div>
            </div>

            <!-- Ringkasan Status + Distribusi -->
            <div class="row">
                <div class="col-12 col-lg-5">
                    <div class="card">
                        <div class="card-header border-0">
                            <h3 class="card-title">Status Pengajuan Client</h3>
                        </div>
                        <div class="card-body">
                            <canvas id="pieStatus" style="min-height:250px; height:280px; max-height:320px; width:100%;"></canvas>
                            <div class="mt-3 small text-muted">
                                Pending: <b><?= number_format($stPending) ?></b> • Disetujui: <b><?= number_format($stDisetujui) ?></b> • Ditolak: <b><?= number_format($stDitolak) ?></b>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-12 col-lg-7">
                    <div class="card">
                        <div class="card-header border-0">
                            <h3 class="card-title">Grafik Bulanan per Layanan  — Tahun <?= $tahun ?></h3>
                        </div>
                        <div class="card-body">
                            <canvas id="barKonsep" style="min-height:300px; height:360px; max-height:420px; width:100%;"></canvas>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Tabel Pengajuan Terbaru -->
            <div class="row">
                <div class="col-12">
                    <div class="card card-outline card-primary">
                        <div class="card-header border-0 d-flex align-items-center justify-content-between">
                            <h3 class="card-title">Pengajuan Terbaru</h3>
                            <a href="?page=pengajuan" class="btn btn-sm btn-primary">Lihat Semua</a>
                        </div>
                        <div class="card-body p-0">
                            <div class="table-responsive">
                                <table class="table table-striped mb-0">
                                    <thead class="thead-light">
                                        <tr>
                                            <th style="width: 58px;">#</th>
                                            <th>Tanggal</th>
                                            <th>Klien</th>
                                            <th>Layanan</th>
                                            <th>Status</th>
                                            <th class="text-right" style="width: 130px;">Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if (empty($latestRows)): ?>
                                            <tr><td colspan="6" class="text-center text-muted">Belum ada data.</td></tr>
                                        <?php else: $no=1; foreach($latestRows as $r): ?>
                                            <tr>
                                                <td><?= $no++ ?></td>
                                                <td><?= htmlspecialchars(date('d/m/Y H:i', strtotime($r['tanggal_pengajuan']))) ?></td>
                                                <td><?= htmlspecialchars($r['nama_lengkap']) ?></td>
                                                <td><?= htmlspecialchars($r['konsep'] ?? '-') ?></td>
                                                <td>
                                                    <?php
                                                    $st = $r['status'];
                                                    $badge = $st==='Pending'?'badge-warning':($st==='Disetujui'?'badge-success':'badge-secondary');
                                                    ?>
                                                    <span class="badge <?= $badge ?>"><?= htmlspecialchars($st) ?></span>
                                                </td>
                                                <td class="text-right">
                                                    <a class="btn btn-xs btn-info" href="?page=detail_pengajuan&id=<?= (int)$r['id'] ?>">Detail</a>
                                                    <?php if (($_SESSION['level'] ?? '')==='ADMIN'): ?>
                                                    <a class="btn btn-xs btn-danger" href="?page=hapus_pengajuan&id=<?= (int)$r['id'] ?>" onclick="return confirm('Hapus data ini?')">Hapus</a>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="card-footer small text-muted">
                            Update: <?= date('d/m/Y H:i') ?>
                        </div>
                    </div>
                </div>
            </div>

        </div><!-- /.container-fluid -->
    </section>
</div>

<!-- Chart.js wajib ada di layout utama -->
<!-- <script src="assets/plugins/chart.js/Chart.min.js"></script> -->

<script>
(function(){
    // Helper warna random (konsisten tapi aman)
    function randColor(alpha) {
        alpha = alpha || 0.85;
        var r = Math.floor(Math.random()*200)+30;
        var g = Math.floor(Math.random()*200)+30;
        var b = Math.floor(Math.random()*200)+30;
        return {
            bg: 'rgba('+r+','+g+','+b+','+alpha+')',
            bd: 'rgba('+Math.max(0,r-25)+','+Math.max(0,g-25)+','+Math.max(0,b-25)+',1)'
        };
    }

    // ---- Pie Status ----
    var pieEl = document.getElementById('pieStatus');
    if (pieEl && window.Chart) {
        var pieCtx = pieEl.getContext('2d');
        var pieData = {
            labels: ['Pending','Disetujui','Ditolak'],
            datasets: [{
                data: [<?= $stPending ?>, <?= $stDisetujui ?>, <?= $stDitolak ?>],
                backgroundColor: ['#f39c12','#00a65a','#6c757d'],
                borderColor: ['#d68910','#0f8d4b','#5b6570'],
                borderWidth: 1
            }]
        };
        var pieOptions = { responsive: true, maintainAspectRatio: false, legend: { position:'bottom' } };
        new Chart(pieCtx, { type: 'doughnut', data: pieData, options: pieOptions });
    }

    // ---- Bar Konsep per Bulan ----
    var barEl = document.getElementById('barKonsep');
    if (barEl && window.Chart) {
        var barCtx = barEl.getContext('2d');
        var labelsBulan = <?= json_encode($labelsBulan) ?>;
        var phpDatasets = <?= json_encode($datasetsKonsep, JSON_UNESCAPED_UNICODE) ?>;
        var ds = phpDatasets.map(function(d){
            var c = randColor(0.85);
            return {
                label: d.label,
                data: (d.data||[]).map(function(v){ return parseInt(v||0); }),
                backgroundColor: c.bg,
                borderColor: c.bd,
                borderWidth: 1.5
            }
        });

        var data = { labels: labelsBulan, datasets: ds };
        var opts = {
            responsive: true, maintainAspectRatio: false, legend: { position: 'bottom' },
            scales: {
                xAxes: [{ gridLines: { display:false } }],
                yAxes: [{
                    ticks: { beginAtZero:true, callback: function(v){ if(v%1===0) return v; } },
                    gridLines: { display:false }
                }]
            },
            tooltips: { intersect:false, mode:'index' }
        };
        new Chart(barCtx, { type: 'bar', data: data, options: opts });
    }
})();
</script>
