<?php
if (!isset($conn)) { die('Koneksi belum tersedia'); }

// ---------- Ambil data ----------
if (!isset($_GET['id'])) {
    echo "<script>window.location.href='?page=anggaran';</script>";
    exit;
}
$id = (int)$_GET['id'];

$sql = "
    SELECT 
        p.*,
        k.nik,
        k.nama_lengkap,
        k.email,
        a.anggaran_tambahan,
        a.detail_anggaran,
        (SELECT nama  FROM tb_konsep   WHERE id = p.konsep)   AS nama_konsep,
        (SELECT nama  FROM tb_produksi WHERE id = p.dekorasi) AS nama_dekorasi,
        (SELECT harga FROM tb_produksi WHERE id = p.dekorasi) AS harga_dekorasi
    FROM tb_pengajuan p
    INNER JOIN tb_klien k    ON p.id_klien = k.id
    INNER JOIN tb_anggaran a ON p.id       = a.id_pengajuan
    WHERE p.id = {$id}
";
$res  = $conn->query($sql);
$data = $res ? $res->fetch_assoc() : null;

if (!$data) {
    echo "<script>alert('Data tidak ditemukan');window.location.href='?page=anggaran';</script>";
    exit;
}

$harga_dekorasi    = (int)($data['harga_dekorasi'] ?? 0);
$anggaran_tambahan = (int)($data['anggaran_tambahan'] ?? 0);
$total             = $harga_dekorasi + $anggaran_tambahan;

// Helper angka
function rupiah($n){ return number_format((int)$n, 0, ",", "."); }
?>
<style>
    /* Tampilan rapi & interaktif */
    .kv-table{width:100%;border-collapse:separate;border-spacing:0}
    .kv-table th,.kv-table td{padding:.6rem .8rem;vertical-align:top;border-bottom:1px solid #eef0f2}
    .kv-table th{width:38%;color:#586170;font-weight:600;white-space:nowrap}
    .kv-table td{color:#1f2937}
    .section-title{font-weight:700;margin:0 0 .75rem;border-left:4px solid #3c8dbc;padding-left:.5rem}
    .soft-card{border:1px solid #e9eef3;border-radius:.75rem;padding:1rem;background:#fff;box-shadow:0 6px 12px rgba(17,24,39,.06)}
    .photo{width:100%;max-width:260px;aspect-ratio:3/4;object-fit:cover;border-radius:.5rem;border:1px solid #e6e6e6;cursor:pointer;transition:transform .2s}
    .photo:hover{transform:scale(1.01)}
    .badge{padding:.35rem .55rem;font-weight:600;border-radius:.35rem}
    .badge-warning{background:#ffc107;color:#111}
    .badge-success{background:#28a745;color:#fff}
    .badge-secondary{background:#6c757d;color:#fff}

    /* Sidebar ringkasan selalu terlihat */
    @media (min-width: 992px){
        .sticky-summary{position:sticky;top:1rem}
    }

    /* Tabel harga rapi */
    .price-table{width:100%;border-collapse:separate;border-spacing:0}
    .price-table th,.price-table td{padding:.55rem .8rem;border-bottom:1px dashed #e6e8eb}
    .price-table th{color:#6b7280;font-weight:600}
    .price-table td.text-right{text-align:right;font-variant-numeric:tabular-nums}

    /* Tombol aksi header kartu */
    .card-actions{gap:.5rem}
    .btn-soft{background:#f7f9fc;border:1px solid #e6ecf2}
    .btn-soft:hover{background:#eef3f8}

    /* Cetak */
    @media print{
        body *{visibility:hidden}
        #section-to-print,#section-to-print *{visibility:visible}
        #section-to-print{position:absolute;left:0;top:0;width:100%}
        .soft-card,.card{box-shadow:none !important;border:1px solid #ddd !important}
        @page{size:landscape;margin:10mm}
        .no-print{display:none !important}
    }
</style>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Header -->
    <section class="content-header no-print">
        <div class="container-fluid">
            <div class="d-flex align-items-center justify-content-between flex-wrap">
                <h1 class="m-0">Detail Anggaran</h1>
                <div class="card-actions d-flex">
                    <a href="?page=anggaran" class="btn btn-outline-secondary">
                        <i class="fas fa-arrow-left mr-1"></i> Kembali
                    </a>
                    <?php if (!empty($data['detail_anggaran'])): ?>
                        <a href="<?= htmlspecialchars($data['detail_anggaran']) ?>" target="_blank" rel="noopener" class="btn btn-soft">
                            <i class="fas fa-file-download mr-1"></i> Download R.A.B
                        </a>
                    <?php endif; ?>
                    <button type="button" id="btn-print" class="btn btn-primary">
                        <i class="fas fa-print mr-1"></i> Cetak
                    </button>
                </div>
            </div>
        </div>
    </section>

    <!-- Main -->
    <section class="content">
        <div class="container-fluid" id="section-to-print">
            <div class="row">
                <!-- Kolom Kiri -->
                <div class="col-lg-7 mb-3">
                    <div class="soft-card mb-3">
                        <div class="section-title">Data Pemohon</div>
                        <div class="d-flex flex-wrap align-items-start">
                            <div class="mr-3 mb-3">
                                <?php if (!empty($data['foto_l'])): ?>
                                    <img src="<?= htmlspecialchars($data['foto_l']) ?>" alt="Foto KTP" class="photo" data-toggle="modal" data-target="#photoModal">
                                <?php else: ?>
                                    <div class="text-muted">Belum mengunggah foto</div>
                                <?php endif; ?>
                            </div>
                            <div class="flex-grow-1">
                                <table class="kv-table">
                                    <tr>
                                        <th>Nama Klien</th>
                                        <td><b><?= htmlspecialchars($data['nama_lengkap'] ?? '-') ?></b></td>
                                    </tr>
                                    <tr>
                                        <th>NIK</th>
                                        <td><?= htmlspecialchars($data['nik_l'] ?? '-') ?></td>
                                    </tr>
                                    <tr>
                                        <th>Nomor Telepon</th>
                                        <td><?= htmlspecialchars($data['nomor_telepon_l'] ?? '-') ?></td>
                                    </tr>
                                    <tr>
                                        <th>Status</th>
                                        <td>
                                            <?php
                                            $status = $data['status'] ?? '-';
                                            $badge  = $status==='Pending' ? 'badge-warning' : ($status==='Disetujui' ? 'badge-success' : 'badge-secondary');
                                            ?>
                                            <span class="badge <?= $badge ?>"><?= htmlspecialchars($status) ?></span>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="soft-card">
                        <div class="section-title">Detail Pengurusan</div>
                        <table class="kv-table">
                            <tr>
                                <th>Layanan</th>
                                <td><?= htmlspecialchars($data['nama_konsep'] ?? '-') ?></td>
                            </tr>
                            <tr>
                                <th>Jasa</th>
                                <td><?= htmlspecialchars($data['nama_dekorasi'] ?? '-') ?></td>
                            </tr>
                            <tr>
                                <th>Anggaran Tambahan</th>
                                <td>
                                    Rp&nbsp;<?= rupiah($anggaran_tambahan) ?>
                                    <?php if (!empty($data['detail_anggaran'])): ?>
                                        <span class="ml-2">
                                            <a href="<?= htmlspecialchars($data['detail_anggaran']) ?>" target="_blank" rel="noopener" class="btn btn-xs btn-outline-info">
                                                <i class="fas fa-file-alt mr-1"></i> Rincian
                                            </a>
                                        </span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <th>Area Pengurusan</th>
                                <td><?= htmlspecialchars($data['tempat_wedding'] ?? '-') ?></td>
                            </tr>
                            <tr>
                                <th>Tanggal Pengurusan</th>
                                <td>
                                    <?php
                                    // format tanggal sederhana aman
                                    $tgl = $data['tanggal_wedding'] ?? '';
                                    echo $tgl && $tgl!=='0000-00-00' ? htmlspecialchars($tgl) : '-';
                                    ?>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>

                <!-- Kolom Kanan (Sticky Summary) -->
                <div class="col-lg-5 mb-3">
                    <div class="soft-card sticky-summary">
                        <div class="d-flex align-items-center justify-content-between mb-2">
                            <div class="section-title m-0">Ringkasan Biaya</div>
                            <span class="badge badge-secondary">ID #<?= (int)$data['id'] ?></span>
                        </div>

                        <table class="price-table mb-3">
                            <tr>
                                <th>Layanan</th>
                                <td class="text-right">Rp&nbsp;0</td>
                            </tr>
                            <tr>
                                <th>Jasa</th>
                                <td class="text-right">Rp&nbsp;<?= rupiah($harga_dekorasi) ?></td>
                            </tr>
                            <tr>
                                <th>Anggaran Tambahan</th>
                                <td class="text-right">Rp&nbsp;<?= rupiah($anggaran_tambahan) ?></td>
                            </tr>
                            <tr>
                                <th style="border-bottom:0;padding-top:.9rem;">Total</th>
                                <td class="text-right" style="border-bottom:0;font-weight:700;padding-top:.9rem;">
                                    Rp&nbsp;<?= rupiah($total) ?>
                                </td>
                            </tr>
                        </table>

                        <div class="d-flex">
                            <a href="?page=anggaran" class="btn btn-outline-secondary mr-2 w-50 no-print">
                                <i class="fas fa-arrow-left mr-1"></i> Kembali
                            </a>
                            <?php if (!empty($data['detail_anggaran'])): ?>
                                <a href="<?= htmlspecialchars($data['detail_anggaran']) ?>" target="_blank" rel="noopener" class="btn btn-soft w-50 no-print">
                                    <i class="fas fa-file-download mr-1"></i> Download R.A.B
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div> <!-- /row -->
        </div> <!-- /container-fluid -->
    </section>

    <!-- Modal Perbesar Foto -->
    <div class="modal fade no-print" id="photoModal" tabindex="-1" aria-labelledby="photoModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content" style="border:0;background:transparent">
                <button type="button" class="close ml-auto mr-2 mt-2 text-white" data-dismiss="modal" aria-label="Close" style="opacity:1;font-size:2rem;">
                    <span aria-hidden="true">&times;</span>
                </button>
                <img src="<?= htmlspecialchars($data['foto_l'] ?? '') ?>" alt="Foto KTP" style="width:100%;height:auto;border-radius:.5rem;box-shadow:0 20px 50px rgba(0,0,0,.35)">
            </div>
        </div>
    </div>
</div>

<script>
document.getElementById('btn-print')?.addEventListener('click', function(){
    window.print();
});
</script>
